/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import net.percederberg.mibble.DefaultContext;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;

public class MibLoader {
    private static final String[] RESOURCE_BASE = new String[]{"mibs/iana", "mibs/ietf"};
    private ArrayList dirs = new ArrayList();
    private ArrayList mibs = new ArrayList();
    private ArrayList queue = new ArrayList();
    private DefaultContext context = new DefaultContext();

    public void addDir(File dir) {
        if (dir != null && !this.dirs.contains(dir)) {
            this.dirs.add(dir);
        }
    }

    public void addDirs(File[] dirs) {
        for (int i = 0; i < dirs.length; ++i) {
            this.addDir(dirs[i]);
        }
    }

    public void addAllDirs(File dir) {
        this.addDir(dir);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            this.addAllDirs(files[i]);
        }
    }

    public void removeDir(File dir) {
        ((AbstractCollection)this.dirs).remove(dir);
    }

    public void removeAllDirs() {
        this.dirs.clear();
    }

    public void reset() {
        this.mibs.clear();
        this.queue.clear();
        this.context = new DefaultContext();
    }

    public MibContext getDefaultContext() {
        return this.context;
    }

    public Mib getMib(String name) {
        for (int i = 0; i < this.mibs.size(); ++i) {
            Mib mib = (Mib)this.mibs.get(i);
            if (!name.equals(mib.getName())) continue;
            return mib;
        }
        return null;
    }

    public Mib[] getAllMibs() {
        Mib[] res = new Mib[this.mibs.size()];
        this.mibs.toArray(res);
        return res;
    }

    private MibSource locate(String name) {
        int i;
        for (i = 0; i < this.dirs.size(); ++i) {
            File dir = (File)this.dirs.get(i);
            File[] files = dir.listFiles(new MibFileFilter(name));
            if (files == null || files.length <= 0) continue;
            return new MibSource(files[0]);
        }
        for (i = 0; i < RESOURCE_BASE.length; ++i) {
            URL url = ClassLoader.getSystemResource(RESOURCE_BASE[i] + "/" + name);
            if (url == null) continue;
            return new MibSource(name, url);
        }
        return null;
    }

    public Mib load(String name) throws FileNotFoundException, MibLoaderException {
        MibSource src = this.locate(name);
        if (src == null) {
            throw new FileNotFoundException("couldn't locate MIB: '" + name + "'");
        }
        return this.load(src);
    }

    public Mib load(File file) throws FileNotFoundException, MibLoaderException {
        return this.load(new MibSource(file));
    }

    private Mib load(MibSource src) throws FileNotFoundException, MibLoaderException {
        int position = this.mibs.size();
        this.queue.clear();
        this.queue.add(src);
        MibLoaderLog log = this.loadQueue();
        if (log.errorCount() > 0) {
            throw new MibLoaderException(log);
        }
        return (Mib)this.mibs.get(position);
    }

    void scheduleLoad(String name) throws FileNotFoundException {
        MibSource src = this.locate(name);
        if (src == null) {
            throw new FileNotFoundException("couldn't locate MIB: '" + name + "'");
        }
        this.scheduleLoad(src);
    }

    void scheduleLoad(File file) {
        this.scheduleLoad(new MibSource(file));
    }

    void scheduleLoad(MibSource src) {
        if (!this.mibs.contains(src.getFile()) && !this.queue.contains(src)) {
            this.queue.add(src);
        }
    }

    private MibLoaderLog loadQueue() throws FileNotFoundException {
        int i;
        MibLoaderLog log = new MibLoaderLog();
        ArrayList<Mib> processed = new ArrayList<Mib>();
        while (this.queue.size() > 0) {
            try {
                MibSource src = (MibSource)this.queue.get(0);
                processed.add(src.createMib(this, log));
            }
            catch (MibLoaderException e) {
                // empty catch block
            }
            this.queue.remove(0);
        }
        this.mibs.addAll(processed);
        for (i = 0; i < processed.size(); ++i) {
            try {
                ((Mib)processed.get(i)).initialize();
                continue;
            }
            catch (MibLoaderException e) {
                // empty catch block
            }
        }
        for (i = 0; i < processed.size(); ++i) {
            try {
                ((Mib)processed.get(i)).validate();
                continue;
            }
            catch (MibLoaderException e) {
                // empty catch block
            }
        }
        if (log.errorCount() > 0) {
            ((AbstractCollection)this.mibs).removeAll(processed);
        }
        return log;
    }

    private class MibFileFilter
    implements FilenameFilter {
        private String basename;

        public MibFileFilter(String name) {
            this.basename = name;
        }

        public boolean accept(File dir, String name) {
            return name.equals(this.basename) || name.startsWith(this.basename + ".");
        }
    }

    private class MibSource {
        private File file = null;
        private URL url = null;

        public MibSource(File file) {
            this.file = file;
        }

        public MibSource(String name, URL url) {
            this.file = new File(name);
            this.url = url;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MibSource) {
                MibSource src = (MibSource)obj;
                if (this.url == null) {
                    return this.file.equals(src.file);
                }
                return this.url.equals(src.url);
            }
            return false;
        }

        public File getFile() {
            return this.file;
        }

        public Mib createMib(MibLoader loader, MibLoaderLog log) throws FileNotFoundException, MibLoaderException {
            if (this.url == null) {
                return new Mib(this.file, loader, log);
            }
            try {
                InputStreamReader input = new InputStreamReader(this.url.openStream());
                return new Mib(input, this.file, loader, log);
            }
            catch (IOException e) {
                throw new FileNotFoundException("couldn't find '" + this.file + "' MIB");
            }
        }
    }
}

