/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.util.ArrayList;
import java.util.BitSet;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ValueReference;

public class BitSetValue
implements MibValue {
    private BitSet value;
    private ArrayList references;

    public BitSetValue(BitSet value) {
        this(value, null);
    }

    public BitSetValue(BitSet value, ArrayList references) {
        this.value = value;
        this.references = references;
    }

    public MibValue initialize(MibLoaderLog log) throws MibException {
        if (this.references != null) {
            int i = 0;
            while (i < this.references.size()) {
                this.initialize(log, (ValueReference)this.references.get(i));
                ++i;
            }
            this.references = null;
        }
        return this;
    }

    private void initialize(MibLoaderLog log, ValueReference ref) throws MibException {
        MibValue value = ref.initialize(log);
        if (!(value instanceof NumberValue)) {
            throw new MibException(ref.getLocation(), "referenced value is not a number");
        }
        this.value.set(((Number)value.toObject()).intValue());
    }

    public ArrayList getBits() {
        ArrayList<NumberValue> components = new ArrayList<NumberValue>();
        int i = 0;
        while (i < this.value.size()) {
            if (this.value.get(i)) {
                components.add(new NumberValue(new Integer(i)));
            }
            ++i;
        }
        return components;
    }

    public Object toObject() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }
}

