/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.value.NumberValue;

public class IntegerType
implements MibType,
MibContext {
    private Constraint constraint = null;
    private HashMap symbols = new HashMap();

    public IntegerType() {
    }

    public IntegerType(Constraint constraint) {
        this.constraint = constraint;
    }

    public IntegerType(ArrayList values) {
        int i = 0;
        while (i < values.size()) {
            if (values.get(i) instanceof MibValueSymbol) {
                MibValueSymbol sym = (MibValueSymbol)values.get(i);
                this.symbols.put(sym.getName(), sym);
                ValueConstraint c = new ValueConstraint(sym.getValue());
                this.constraint = this.constraint == null ? c : new CompoundConstraint(this.constraint, c);
            }
            ++i;
        }
    }

    public MibType initialize(MibLoaderLog log) throws MibException {
        Iterator iter = this.symbols.values().iterator();
        if (this.constraint != null) {
            this.constraint.initialize(log);
        }
        while (iter.hasNext()) {
            MibValueSymbol sym = (MibValueSymbol)iter.next();
            sym.initialize(log);
            if (this.isCompatibleType(sym.getValue())) continue;
            String message = "value is not compatible with type";
            throw new MibException(sym.getLocation(), message);
        }
        return this;
    }

    public boolean hasConstraint() {
        return this.constraint != null;
    }

    public boolean hasSymbols() {
        return this.symbols.size() > 0;
    }

    public boolean isCompatible(MibValue value) {
        return this.isCompatibleType(value) && (this.constraint == null || this.constraint.isCompatible(value));
    }

    private boolean isCompatibleType(MibValue value) {
        return value instanceof NumberValue && !(value.toObject() instanceof Float);
    }

    public MibSymbol getSymbol(String name) {
        return (MibSymbol)this.symbols.get(name);
    }

    public String toString() {
        if (this.constraint == null) {
            return "INTEGER";
        }
        return "INTEGER (" + this.constraint.toString() + ")";
    }
}

