/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.value.NumberValue;

public class SnmpTrapType
implements MibType {
    private MibValue enterprise;
    private ArrayList variables;
    private String description;
    private String reference;

    public SnmpTrapType(MibValue enterprise, ArrayList variables, String description, String reference) {
        this.enterprise = enterprise;
        this.variables = variables;
        this.description = description;
        this.reference = reference;
    }

    public MibType initialize(MibLoaderLog log) throws MibException {
        ArrayList<MibValue> list = new ArrayList<MibValue>();
        this.enterprise = this.enterprise.initialize(log);
        int i = 0;
        while (i < this.variables.size()) {
            list.add(((MibValue)this.variables.get(i)).initialize(log));
            ++i;
        }
        this.variables = list;
        return this;
    }

    public boolean isCompatible(MibValue value) {
        return value instanceof NumberValue && !(value.toObject() instanceof Float);
    }

    public MibValue getEnterprise() {
        return this.enterprise;
    }

    public ArrayList getVariables() {
        return this.variables;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TRAP-TYPE (");
        buffer.append("\n  Enterprise: ");
        buffer.append(this.enterprise);
        buffer.append("\n  Variables: ");
        buffer.append(this.variables);
        if (this.description != null) {
            buffer.append("\n  Description: ");
            buffer.append(this.description);
        }
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

