/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpStatus;

public class SnmpTextualConvention
implements MibType,
MibContext {
    private String displayHint;
    private SnmpStatus status;
    private String description;
    private String reference;
    private MibType syntax;

    public SnmpTextualConvention(String displayHint, SnmpStatus status, String description, String reference, MibType syntax) {
        this.displayHint = displayHint;
        this.status = status;
        this.description = description;
        this.reference = reference;
        this.syntax = syntax;
    }

    public MibType initialize(MibLoaderLog log) throws MibException {
        this.syntax = this.syntax.initialize(log);
        return this;
    }

    public boolean isCompatible(MibValue value) {
        return false;
    }

    public String getDisplayHint() {
        return this.displayHint;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public MibSymbol getSymbol(String name) {
        if (this.syntax instanceof MibContext) {
            return ((MibContext)((Object)this.syntax)).getSymbol(name);
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TEXTUAL-CONVENTION (");
        if (this.displayHint != null) {
            buffer.append("\n  Display-Hint: ");
            buffer.append(this.displayHint);
        }
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.description);
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        buffer.append("\n  Syntax: ");
        buffer.append(this.syntax);
        buffer.append("\n)");
        return buffer.toString();
    }
}

