/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpNotificationType
implements MibType {
    private ArrayList objects;
    private SnmpStatus status;
    private String description;
    private String reference;

    public SnmpNotificationType(ArrayList objects, SnmpStatus status, String description, String reference) {
        this.objects = objects;
        this.status = status;
        this.description = description;
        this.reference = reference;
    }

    public MibType initialize(MibLoaderLog log) throws MibException {
        ArrayList<MibValue> list = new ArrayList<MibValue>();
        int i = 0;
        while (i < this.objects.size()) {
            MibValue value = (MibValue)this.objects.get(i);
            list.add(value.initialize(log));
            ++i;
        }
        this.objects = list;
        return this;
    }

    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public ArrayList getObjects() {
        return this.objects;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("NOTIFICATION-TYPE (");
        buffer.append("\n  Objects: ");
        buffer.append(this.objects);
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.description);
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

