/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import net.percederberg.mibble.LogEntry;
import net.percederberg.mibble.LogPrinter;

public class SimpleLogPrinter
implements LogPrinter {
    private PrintWriter output;
    private int margin;

    public SimpleLogPrinter(PrintStream output, int margin) {
        this(new PrintWriter(output), margin);
    }

    public SimpleLogPrinter(PrintWriter output, int margin) {
        this.output = output;
        this.margin = margin;
    }

    public void print(LogEntry entry) {
        StringBuffer buffer = new StringBuffer();
        switch (entry.getType()) {
            case 2: {
                buffer.append("Error: ");
                break;
            }
            case 3: {
                buffer.append("Warning: ");
                break;
            }
            default: {
                buffer.append("Internal Error: ");
            }
        }
        buffer.append("in ");
        buffer.append(this.relativeFilename(entry.getFile()));
        if (entry.getLineNumber() > 0) {
            buffer.append(": line ");
            buffer.append(entry.getLineNumber());
        }
        buffer.append(":\n");
        buffer.append(this.linebreakString(entry.getMessage(), "    ", this.margin));
        String line = entry.readLine();
        if (line != null) {
            buffer.append("\n\n");
            buffer.append(line);
            buffer.append("\n");
            int i = 1;
            while (i < entry.getColumnNumber()) {
                if (line.charAt(i - 1) == '\t') {
                    buffer.append("\t");
                } else {
                    buffer.append(" ");
                }
                ++i;
            }
            buffer.append("^");
        }
        this.output.println(buffer.toString());
        this.output.flush();
    }

    private String relativeFilename(File file) {
        try {
            String currentPath = new File(".").getCanonicalPath();
            String filePath = file.getCanonicalPath();
            if (filePath.startsWith(currentPath)) {
                if ((filePath = filePath.substring(currentPath.length())).charAt(0) == '/' || filePath.charAt(0) == '\\') {
                    return filePath.substring(1);
                }
                return filePath;
            }
        }
        catch (IOException e) {}
        return file.toString();
    }

    private String linebreakString(String str, String prefix, int length) {
        StringBuffer buffer = new StringBuffer();
        while (str.length() + prefix.length() > length) {
            int pos = str.lastIndexOf(32, length - prefix.length());
            if (pos < 0 && (pos = str.indexOf(32)) < 0) break;
            buffer.append(prefix);
            buffer.append(str.substring(0, pos));
            str = str.substring(pos + 1);
            buffer.append("\n");
        }
        buffer.append(prefix);
        buffer.append(str);
        return buffer.toString();
    }
}

