/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileNotFoundException;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;

public class MibbleValidator {
    private static final String COMMAND_HELP = "Validates a set of SNMP MIB files. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibbleValidator <file(s)>";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";

    public static void main(String[] args) {
        int errors = 0;
        int warnings = 0;
        if (args.length < 1) {
            MibbleValidator.printHelp("No file(s) specified");
            System.exit(1);
        }
        int i = 0;
        while (i < args.length) {
            try {
                System.out.print("Reading " + args[i] + "... ");
                System.out.flush();
                File file = new File(args[i]);
                MibLoader loader = new MibLoader();
                loader.addDir(file.getParentFile());
                Mib mib = loader.load(file);
                System.out.println("[OK]");
                if (mib.getLog().warningCount() > 0) {
                    mib.getLog().printTo(System.out);
                    ++warnings;
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("[FAILED]");
                MibbleValidator.printError(args[i], e);
                ++errors;
            }
            catch (MibLoaderException e) {
                System.out.println("[FAILED]");
                e.getLog().printTo(System.out);
                ++errors;
            }
            catch (RuntimeException e) {
                System.out.println();
                MibbleValidator.printInternalError(e);
                System.exit(1);
            }
            ++i;
        }
        System.out.println();
        System.out.println("Files processed:  " + args.length);
        System.out.println("  with errors:    " + errors);
        System.out.println("  with warnings:  " + warnings);
        if (errors > 0) {
            System.err.println("Error: validation errors were encountered");
        }
        System.exit(errors);
    }

    private static void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            System.err.print("Error: ");
            System.err.println(error);
            System.err.println();
        }
    }

    private static void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private static void printError(String file, FileNotFoundException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: couldn't open file:");
        buffer.append("\n    ");
        buffer.append(file);
        System.out.println(buffer.toString());
    }
}

