/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.ArrayList;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;

class MibReference
implements MibContext {
    private MibLoader loader;
    private Mib mib = null;
    private FileLocation location;
    private String name;
    private ArrayList symbols;

    public MibReference(MibLoader loader, FileLocation location, String name, ArrayList symbols) {
        this.loader = loader;
        this.location = location;
        this.name = name;
        this.symbols = symbols;
    }

    public void initialize(MibLoaderLog log) throws MibException {
        this.mib = this.loader.getMib(this.name);
        if (this.mib == null) {
            String message = "couldn't find referenced MIB '" + this.name + "'";
            throw new MibException(this.location, message);
        }
        if (this.symbols != null) {
            int i = 0;
            while (i < this.symbols.size()) {
                if (this.mib.getSymbol(this.symbols.get(i).toString()) == null) {
                    String message = "couldn't find imported symbol '" + this.symbols.get(i) + "' in MIB '" + this.name + "'";
                    throw new MibException(this.location, message);
                }
                ++i;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public MibSymbol getSymbol(String name) {
        if (this.mib == null) {
            return null;
        }
        if (this.symbols != null && !this.symbols.contains(name)) {
            return null;
        }
        return this.mib.getSymbol(name);
    }

    public String toString() {
        return this.name;
    }
}

