/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.FileNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.mibble.CompoundContext;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibReference;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.NamedNumber;
import net.percederberg.mibble.asn1.Asn1Analyzer;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpAgentCapabilities;
import net.percederberg.mibble.snmp.SnmpCompliance;
import net.percederberg.mibble.snmp.SnmpModule;
import net.percederberg.mibble.snmp.SnmpModuleCompliance;
import net.percederberg.mibble.snmp.SnmpModuleIdentity;
import net.percederberg.mibble.snmp.SnmpModuleSupport;
import net.percederberg.mibble.snmp.SnmpNotificationGroup;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.snmp.SnmpObjectGroup;
import net.percederberg.mibble.snmp.SnmpObjectIdentity;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpRevision;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpTextualConvention;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.snmp.SnmpVariation;
import net.percederberg.mibble.type.BitSetType;
import net.percederberg.mibble.type.BooleanType;
import net.percederberg.mibble.type.ChoiceType;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ElementType;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.NullType;
import net.percederberg.mibble.type.ObjectIdentifierType;
import net.percederberg.mibble.type.RealType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.TypeReference;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.BitSetValue;
import net.percederberg.mibble.value.BooleanValue;
import net.percederberg.mibble.value.NullValue;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;
import net.percederberg.mibble.value.StringValue;
import net.percederberg.mibble.value.ValueReference;

class MibAnalyzer
extends Asn1Analyzer {
    private Mib mib;
    private MibLoaderLog log;
    private MibContext baseContext;
    private ArrayList contextStack = new ArrayList();

    public MibAnalyzer(Mib mib) {
        this.mib = mib;
        this.log = mib.getLog();
        this.baseContext = mib.getLoader().getDefaultContext();
        this.baseContext = new CompoundContext(mib, this.baseContext);
        this.pushContext(this.baseContext);
    }

    protected Node exitBinaryString(Token node) {
        String str = node.getImage();
        Number value = (str = str.substring(1, str.length() - 2)).length() == 0 ? (Number)new Integer(0) : (Number)(str.length() < 32 ? (Number)new Integer(Integer.parseInt(str, 2)) : (Number)(str.length() < 64 ? new Long(Long.parseLong(str, 2)) : new BigInteger(str, 2)));
        node.addValue((Object)value);
        return node;
    }

    protected Node exitHexadecimalString(Token node) {
        String str = node.getImage();
        Number value = (str = str.substring(1, str.length() - 2)).length() == 0 ? (Number)new Integer(0) : (Number)(str.length() < 8 ? (Number)new Integer(Integer.parseInt(str, 16)) : (Number)(str.length() < 16 ? new Long(Long.parseLong(str, 16)) : new BigInteger(str, 16)));
        node.addValue((Object)value);
        return node;
    }

    protected Node exitQuotedString(Token node) {
        int pos;
        String str = node.getImage();
        str = str.substring(1, str.length() - 1);
        do {
            if ((pos = str.indexOf("\"\"")) < 0) continue;
            str = str.substring(0, pos) + '\"' + str.substring(pos + 2);
        } while (pos >= 0);
        node.addValue((Object)str);
        return node;
    }

    protected Node exitIdentifierString(Token node) {
        node.addValue((Object)node.getImage());
        return node;
    }

    protected Node exitNumberString(Token node) {
        String str = node.getImage();
        Number value = str.length() < 10 ? (Number)new Integer(str) : (Number)(str.length() < 19 ? new Long(str) : new BigInteger(str));
        node.addValue((Object)value);
        return node;
    }

    protected Node exitModuleDefinition(Production node) throws ParseException {
        this.mib.setName(this.getStringValue(this.getChildAt((Node)node, 0), 0));
        return null;
    }

    protected Node exitModuleIdentifier(Production node) throws ParseException {
        node.addValue((Object)this.getStringValue(this.getChildAt((Node)node, 0), 0));
        return node;
    }

    protected Node exitModuleReference(Production node) throws ParseException {
        node.addValue((Object)this.getStringValue(this.getChildAt((Node)node, 0), 0));
        return node;
    }

    protected Node exitImportList(Production node) {
        ArrayList references = this.getChildValues((Node)node);
        MibContext current = this.mib.getLoader().getDefaultContext();
        int i = references.size() - 1;
        while (i >= 0) {
            MibReference ref = (MibReference)references.get(i);
            current = new CompoundContext(ref, current);
            --i;
        }
        this.baseContext = new CompoundContext(this.mib, current);
        this.popContext();
        this.pushContext(this.baseContext);
        return null;
    }

    protected Node exitSymbolsFromModule(Production node) throws ParseException {
        Node child = this.getChildAt((Node)node, 0);
        ArrayList symbols = child.getAllValues();
        if (symbols == null) {
            symbols = new ArrayList();
        }
        child = this.getChildAt((Node)node, 2);
        String module = this.getStringValue(child, 0);
        MibReference ref = new MibReference(this.mib.getLoader(), this.getLocation(child), module, symbols);
        try {
            this.mib.getLoader().scheduleLoad(module);
        }
        catch (FileNotFoundException e) {
            throw new ParseException(6, "couldn't find imported MIB: " + module, child.getStartLine(), child.getStartColumn());
        }
        this.mib.addImport(ref);
        node.addValue((Object)ref);
        return node;
    }

    protected Node exitSymbolList(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSymbol(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitTypeAssignment(Production node) throws ParseException {
        String name = this.getStringValue(this.getChildAt((Node)node, 0), 0);
        if (this.mib.getSymbol(name) != null) {
            throw new ParseException(6, "a symbol '" + name + "' already present in the MIB", node.getStartLine(), node.getStartColumn());
        }
        if (!Character.isUpperCase(name.charAt(0))) {
            this.log.addWarning(this.getLocation((Node)node), "type identifier '" + name + "' doesn't " + "start with an uppercase character");
        }
        MibType type = (MibType)this.getValue(this.getChildAt((Node)node, 2), 0);
        MibTypeSymbol symbol = new MibTypeSymbol(this.getLocation((Node)node), name, type);
        this.mib.addSymbol(symbol);
        return null;
    }

    protected Node exitType(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitDefinedType(Production node) throws ParseException {
        MibContext local = this.getContext();
        String name = null;
        Object value = null;
        FileLocation loc = this.getLocation((Node)node);
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2004: {
                    name = this.getStringValue(child, 0);
                    local = this.mib.getImport(name);
                    if (local != null) break;
                    throw new ParseException(6, "referenced module not imported '" + name + "'", child.getStartLine(), child.getStartColumn());
                }
                case 1104: {
                    name = this.getStringValue(child, 0);
                    break;
                }
                case 2044: {
                    value = this.getValue(child, 0);
                }
            }
            ++i;
        }
        value = value instanceof Constraint ? new TypeReference(loc, local, name, (Constraint)value) : (value instanceof ArrayList ? new TypeReference(loc, local, name, (ArrayList)value) : new TypeReference(loc, local, name));
        node.addValue(value);
        return node;
    }

    protected Node exitBuiltinType(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitNullType(Production node) {
        node.addValue((Object)NullType.TYPE);
        return node;
    }

    protected Node exitBooleanType(Production node) {
        node.addValue((Object)BooleanType.TYPE);
        return node;
    }

    protected Node exitRealType(Production node) {
        node.addValue((Object)RealType.TYPE);
        return node;
    }

    protected Node exitIntegerType(Production node) {
        Object obj;
        ArrayList values = this.getChildValues((Node)node);
        IntegerType type = values.size() == 0 ? new IntegerType() : ((obj = values.get(0)) instanceof ArrayList ? new IntegerType((ArrayList)obj) : new IntegerType((Constraint)obj));
        node.addValue((Object)type);
        return node;
    }

    protected Node exitObjectIdentifierType(Production node) {
        node.addValue((Object)ObjectIdentifierType.TYPE);
        return node;
    }

    protected Node exitStringType(Production node) {
        ArrayList values = this.getChildValues((Node)node);
        StringType type = values.size() == 0 ? new StringType() : new StringType((Constraint)values.get(0));
        node.addValue((Object)type);
        return node;
    }

    protected Node exitBitStringType(Production node) {
        Object obj;
        ArrayList values = this.getChildValues((Node)node);
        BitSetType type = values.size() == 0 ? new BitSetType() : ((obj = values.get(0)) instanceof ArrayList ? new BitSetType((ArrayList)obj) : new BitSetType((Constraint)obj));
        node.addValue((Object)type);
        return node;
    }

    protected Node exitBitsType(Production node) {
        return this.exitBitStringType(node);
    }

    protected Node exitSequenceType(Production node) {
        ArrayList elements = this.getChildValues((Node)node);
        node.addValue((Object)new SequenceType(elements));
        return node;
    }

    protected Node exitSequenceOfType(Production node) throws ParseException {
        Constraint c = null;
        Node child = this.getChildAt((Node)node, node.getChildCount() - 1);
        MibType type = (MibType)this.getValue(child, 0);
        if (node.getChildCount() == 4) {
            child = this.getChildAt((Node)node, 1);
            c = (Constraint)this.getValue(child, 0);
        }
        node.addValue((Object)new SequenceOfType(type, c));
        return node;
    }

    protected Node exitSetType(Production node) {
        this.log.addError(this.getLocation((Node)node), "SET type currently unsupported");
        node.addValue((Object)NullType.TYPE);
        return node;
    }

    protected Node exitSetOfType(Production node) {
        this.log.addError(this.getLocation((Node)node), "SET OF type currently unsupported");
        node.addValue((Object)NullType.TYPE);
        return node;
    }

    protected Node exitChoiceType(Production node) {
        node.addValue((Object)new ChoiceType(this.getChildValues((Node)node)));
        return node;
    }

    protected Node exitEnumeratedType(Production node) {
        this.log.addError(this.getLocation((Node)node), "ENUMERATED type currently unsupported");
        node.addValue((Object)NullType.TYPE);
        return node;
    }

    protected Node exitSelectionType(Production node) {
        this.log.addError(this.getLocation((Node)node), "selection type currently unsupported");
        node.addValue((Object)NullType.TYPE);
        return node;
    }

    protected Node exitTaggedType(Production node) throws ParseException {
        Node child = this.getChildAt((Node)node, node.getChildCount() - 1);
        MibType type = (MibType)this.getValue(child, 0);
        node.addValue((Object)type);
        return node;
    }

    protected Node exitAnyType(Production node) {
        this.log.addError(this.getLocation((Node)node), "ANY type currently unsupported");
        node.addValue((Object)NullType.TYPE);
        return node;
    }

    protected Node exitElementTypeList(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitElementType(Production node) throws ParseException {
        String name = null;
        Node child = this.getChildAt((Node)node, 0);
        if (child.getId() == 1104) {
            name = this.getStringValue(child, 0);
            child = this.getChildAt((Node)node, 1);
        }
        if (child.getId() != 2018) {
            throw new ParseException(6, "referencing components is currently unsupported", child.getStartLine(), child.getStartColumn());
        }
        MibType type = (MibType)this.getValue(child, 0);
        node.addValue((Object)new ElementType(name, type));
        return node;
    }

    protected Node exitOptionalOrDefaultElement(Production node) {
        this.log.addError(this.getLocation((Node)node), "optional and default elements are currently unsupported");
        return null;
    }

    protected Node exitValueOrConstraintList(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitNamedNumberList(Production node) {
        node.addValue((Object)this.getChildValues((Node)node));
        return node;
    }

    protected Node exitNamedNumber(Production node) throws ParseException {
        String name = this.getStringValue(this.getChildAt((Node)node, 0), 0);
        MibValue value = (MibValue)this.getValue(this.getChildAt((Node)node, 2), 0);
        MibValueSymbol symbol = new MibValueSymbol(this.getLocation((Node)node), name, null, value);
        node.addValue((Object)symbol);
        return node;
    }

    protected Node exitNumber(Production node) throws ParseException {
        MibValue value;
        Node child = this.getChildAt((Node)node, 0);
        if (child.getId() == 1012) {
            Number number = (Number)this.getValue(this.getChildAt((Node)node, 1), 0);
            number = number instanceof Integer ? (Number)new Integer(-number.intValue()) : (Number)(number instanceof Long ? new Long(-number.longValue()) : ((BigInteger)number).negate());
            value = new NumberValue(number);
        } else if (child.getId() == 1105) {
            Number number = (Number)this.getValue(this.getChildAt((Node)node, 0), 0);
            value = new NumberValue(number);
        } else {
            value = (MibValue)this.getValue(this.getChildAt((Node)node, 0), 0);
        }
        node.addValue((Object)value);
        return node;
    }

    protected Node exitConstraintList(Production node) {
        Constraint result = null;
        ArrayList values = this.getChildValues((Node)node);
        int i = values.size() - 1;
        while (i >= 0) {
            Constraint c = (Constraint)values.get(i);
            result = result == null ? c : new CompoundConstraint(c, result);
            --i;
        }
        node.addValue(result);
        return node;
    }

    protected Node exitConstraint(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitValueConstraintList(Production node) {
        return this.exitConstraintList(node);
    }

    protected Node exitValueConstraint(Production node) throws ParseException {
        Constraint obj;
        ArrayList list = this.getChildValues((Node)node);
        MibValue lower = null;
        MibValue upper = null;
        Boolean strictLower = null;
        Boolean strictUpper = null;
        if (list.size() == 0) {
            throw new ParseException(6, "no value specified in constraint", node.getStartLine(), node.getStartColumn());
        }
        if (list.size() == 1) {
            lower = (MibValue)list.get(0);
            obj = new ValueConstraint(lower);
        } else {
            int i = 0;
            while (i < list.size()) {
                obj = list.get(i);
                if (obj instanceof Boolean && strictLower == null) {
                    strictLower = (Boolean)((Object)obj);
                } else if (obj instanceof Boolean) {
                    strictUpper = (Boolean)((Object)obj);
                } else if (strictLower == null) {
                    lower = (MibValue)((Object)obj);
                } else {
                    upper = (MibValue)((Object)obj);
                }
                ++i;
            }
            obj = new ValueRangeConstraint(lower, strictLower, upper, strictUpper);
        }
        node.addValue((Object)obj);
        return node;
    }

    protected Node exitValueRange(Production node) throws ParseException {
        Node child = this.getChildAt((Node)node, 0);
        if (child.getId() == 1013) {
            node.addValue((Object)Boolean.TRUE);
        } else {
            node.addValue((Object)Boolean.FALSE);
        }
        child = this.getChildAt((Node)node, node.getChildCount() - 1);
        node.addValue(child.getValue(0));
        child = this.getChildAt((Node)node, node.getChildCount() - 2);
        if (child.getId() == 1013) {
            node.addValue((Object)Boolean.TRUE);
        } else {
            node.addValue((Object)Boolean.FALSE);
        }
        return node;
    }

    protected Node exitLowerEndPoint(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitUpperEndPoint(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSizeConstraint(Production node) throws ParseException {
        Constraint c = (Constraint)this.getValue(this.getChildAt((Node)node, 1), 0);
        node.addValue((Object)new SizeConstraint(c));
        return node;
    }

    protected Node exitAlphabetConstraint(Production node) {
        this.log.addError(this.getLocation((Node)node), "FROM constraints are currently unsupported");
        return null;
    }

    protected Node exitContainedTypeConstraint(Production node) {
        this.log.addError(this.getLocation((Node)node), "INCLUDES constraints are currently unsupported");
        return null;
    }

    protected Node exitInnerTypeConstraint(Production node) {
        this.log.addError(this.getLocation((Node)node), "WITH COMPONENT(S) constraints are currently unsupported");
        return null;
    }

    protected Node exitValueAssignment(Production node) throws ParseException {
        String name = this.getStringValue(this.getChildAt((Node)node, 0), 0);
        if (this.mib.getSymbol(name) != null) {
            throw new ParseException(6, "a symbol '" + name + "' already present in the MIB", node.getStartLine(), node.getStartColumn());
        }
        if (!Character.isLowerCase(name.charAt(0))) {
            this.log.addWarning(this.getLocation((Node)node), "value identifier '" + name + "' doesn't " + "start with an lowercase character");
        }
        MibType type = (MibType)this.getValue(this.getChildAt((Node)node, 1), 0);
        MibValue value = (MibValue)this.getValue(this.getChildAt((Node)node, 3), 0);
        MibValueSymbol symbol = new MibValueSymbol(this.getLocation((Node)node), name, type, value);
        this.mib.addSymbol(symbol);
        return null;
    }

    protected Node exitValue(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitDefinedValue(Production node) throws ParseException {
        String name;
        MibContext local = this.getContext();
        Node child = this.getChildAt((Node)node, 0);
        if (child.getId() == 2004) {
            name = this.getStringValue(child, 0);
            local = this.mib.getImport(name);
            if (local == null) {
                throw new ParseException(6, "referenced module not imported '" + name + "'", child.getStartLine(), child.getStartColumn());
            }
            child = this.getChildAt((Node)node, 1);
        }
        name = this.getStringValue(child, 0);
        ValueReference ref = new ValueReference(this.getLocation((Node)node), local, name);
        node.addValue((Object)ref);
        return node;
    }

    protected Node exitBuiltinValue(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitNullValue(Production node) {
        node.addValue((Object)NullValue.NULL);
        return node;
    }

    protected Node exitBooleanValue(Production node) throws ParseException {
        Node child = this.getChildAt((Node)node, 0);
        if (child.getId() == 1057) {
            node.addValue((Object)BooleanValue.TRUE);
        } else {
            node.addValue((Object)BooleanValue.FALSE);
        }
        return node;
    }

    protected Node exitSpecialRealValue(Production node) throws ParseException {
        Float number = this.getChildAt((Node)node, 0).getId() == 1059 ? new Float(Float.POSITIVE_INFINITY) : new Float(Float.NEGATIVE_INFINITY);
        node.addValue((Object)new NumberValue(number));
        return node;
    }

    protected Node exitNumberValue(Production node) throws ParseException {
        Number number;
        number = this.getChildAt((Node)node, 0).getId() == 1012 ? (Number)((number = (Number)this.getValue(this.getChildAt((Node)node, 1), 0)) instanceof Integer ? (Number)new Integer(-number.intValue()) : (Number)(number instanceof Long ? new Long(-number.longValue()) : ((BigInteger)number).negate())) : (Number)((Number)this.getValue(this.getChildAt((Node)node, 0), 0));
        node.addValue((Object)new NumberValue(number));
        return node;
    }

    protected Node exitBinaryValue(Production node) throws ParseException {
        Number number = (Number)this.getValue(this.getChildAt((Node)node, 0), 0);
        node.addValue((Object)new NumberValue(number));
        return node;
    }

    protected Node exitHexadecimalValue(Production node) throws ParseException {
        Number number = (Number)this.getValue(this.getChildAt((Node)node, 0), 0);
        node.addValue((Object)new NumberValue(number));
        return node;
    }

    protected Node exitStringValue(Production node) throws ParseException {
        String str = this.getStringValue(this.getChildAt((Node)node, 0), 0);
        node.addValue((Object)new StringValue(str));
        return node;
    }

    protected Node exitBitOrObjectIdentifierValue(Production node) throws ParseException {
        if (this.isBitValue((Node)node)) {
            return this.exitBitValue(node);
        }
        return this.exitObjectIdentifierValue(node);
    }

    protected Node exitBitValue(Production node) throws ParseException {
        ArrayList components = this.getChildValues((Node)node);
        BitSet bits = new BitSet();
        ArrayList<ValueReference> values = new ArrayList<ValueReference>();
        int i = 0;
        while (i < components.size()) {
            NamedNumber number = (NamedNumber)components.get(i);
            if (number.hasNumber()) {
                bits.set(number.getNumber().intValue());
            } else {
                values.add(number.getReference());
            }
            ++i;
        }
        node.addValue((Object)new BitSetValue(bits, values));
        return node;
    }

    protected Node exitObjectIdentifierValue(Production node) throws ParseException {
        ArrayList components = this.getChildValues((Node)node);
        MibValue parent = null;
        if (components.size() < 1) {
            throw new ParseException(6, "object identifier must contain at least one component", node.getStartLine(), node.getStartColumn());
        }
        int i = 0;
        while (i < components.size()) {
            NamedNumber number = (NamedNumber)components.get(i);
            if (number.hasNumber()) {
                int value = number.getNumber().intValue();
                parent = parent instanceof ObjectIdentifierValue ? new ObjectIdentifierValue((ObjectIdentifierValue)parent, number.getName(), value) : new ObjectIdentifierValue((ValueReference)parent, number.getName(), value);
            } else {
                if (parent != null) {
                    throw new ParseException(6, "object identifier component '" + number.getName() + "' has been previously defined, remove any " + "components to the left", node.getStartLine(), node.getStartColumn());
                }
                parent = number.getReference();
            }
            ++i;
        }
        node.addValue(parent);
        return node;
    }

    protected Node exitNameValueList(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitNameValueComponent(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitNameOrNumber(Production node) throws ParseException {
        NamedNumber value;
        Object obj = this.getValue(this.getChildAt((Node)node, 0), 0);
        if (obj instanceof Number) {
            value = new NamedNumber((Number)obj);
        } else if (obj instanceof String) {
            ValueReference ref = new ValueReference(this.getLocation((Node)node), this.getContext(), (String)obj);
            value = new NamedNumber((String)obj, ref);
        } else {
            value = (NamedNumber)obj;
        }
        node.addValue((Object)value);
        return node;
    }

    protected Node exitNameAndNumber(Production node) throws ParseException {
        String name = this.getStringValue(this.getChildAt((Node)node, 0), 0);
        Object obj = this.getValue(this.getChildAt((Node)node, 2), 0);
        NamedNumber value = obj instanceof Number ? new NamedNumber(name, (Number)obj) : new NamedNumber(name, (ValueReference)obj);
        node.addValue((Object)value);
        return node;
    }

    protected Node exitDefinedMacroType(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpModuleIdentityMacroType(Production node) throws ParseException {
        ArrayList<Object> revisions = new ArrayList<Object>();
        String update = this.getStringValue(this.getChildAt((Node)node, 1), 0);
        String org = this.getStringValue(this.getChildAt((Node)node, 2), 0);
        String contact = this.getStringValue(this.getChildAt((Node)node, 3), 0);
        String desc = this.getStringValue(this.getChildAt((Node)node, 4), 0);
        int i = 5;
        while (i < node.getChildCount()) {
            revisions.add(this.getValue(this.getChildAt((Node)node, i), 0));
            ++i;
        }
        node.addValue((Object)new SnmpModuleIdentity(update, org, contact, desc, revisions));
        return node;
    }

    protected Node exitSnmpObjectIdentityMacroType(Production node) throws ParseException {
        SnmpStatus status = (SnmpStatus)this.getValue(this.getChildAt((Node)node, 1), 0);
        String desc = this.getStringValue(this.getChildAt((Node)node, 2), 0);
        String ref = node.getChildCount() <= 3 ? null : this.getStringValue(this.getChildAt((Node)node, 3), 0);
        node.addValue((Object)new SnmpObjectIdentity(status, desc, ref));
        return node;
    }

    protected void childSnmpObjectTypeMacroType(Production node, Node child) throws ParseException {
        MibType type;
        if (child.getId() == 2101 && (type = (MibType)this.getValue(child, 0)) instanceof MibContext) {
            this.pushContextExtension((MibContext)((Object)type));
        }
        node.addChild(child);
    }

    protected Node exitSnmpObjectTypeMacroType(Production node) throws ParseException {
        MibType syntax = null;
        String units = null;
        SnmpAccess access = null;
        SnmpStatus status = null;
        String desc = null;
        String ref = null;
        Object index = null;
        MibValue defVal = null;
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2101: {
                    syntax = (MibType)this.getValue(child, 0);
                    if (!(syntax instanceof MibContext)) break;
                    this.popContext();
                    break;
                }
                case 2102: {
                    units = this.getStringValue(child, 0);
                    break;
                }
                case 2103: {
                    access = (SnmpAccess)this.getValue(child, 0);
                    break;
                }
                case 2099: {
                    status = (SnmpStatus)this.getValue(child, 0);
                    break;
                }
                case 2097: {
                    desc = this.getStringValue(child, 0);
                    break;
                }
                case 2100: {
                    ref = this.getStringValue(child, 0);
                    break;
                }
                case 2104: {
                    index = this.getValue(child, 0);
                    break;
                }
                case 2108: {
                    defVal = (MibValue)this.getValue(child, 0);
                }
            }
            ++i;
        }
        SnmpObjectType type = index instanceof ArrayList ? new SnmpObjectType(syntax, units, access, status, desc, ref, (ArrayList)index, defVal) : new SnmpObjectType(syntax, units, access, status, desc, ref, (MibValue)index, defVal);
        node.addValue((Object)type);
        return node;
    }

    protected Node exitSnmpNotificationTypeMacroType(Production node) throws ParseException {
        ArrayList objects = new ArrayList();
        SnmpStatus status = null;
        String desc = null;
        String ref = null;
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2109: {
                    objects = (ArrayList)this.getValue(child, 0);
                    break;
                }
                case 2099: {
                    status = (SnmpStatus)this.getValue(child, 0);
                    break;
                }
                case 2097: {
                    desc = this.getStringValue(child, 0);
                    break;
                }
                case 2100: {
                    ref = this.getStringValue(child, 0);
                }
            }
            ++i;
        }
        node.addValue((Object)new SnmpNotificationType(objects, status, desc, ref));
        return node;
    }

    protected Node exitSnmpTrapTypeMacroType(Production node) throws ParseException {
        MibValue enterprise = null;
        ArrayList vars = new ArrayList();
        String desc = null;
        String ref = null;
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2111: {
                    enterprise = (MibValue)this.getValue(child, 0);
                    break;
                }
                case 2112: {
                    vars = child.getAllValues();
                    break;
                }
                case 2097: {
                    desc = this.getStringValue(child, 0);
                    break;
                }
                case 2100: {
                    ref = this.getStringValue(child, 0);
                }
            }
            ++i;
        }
        node.addValue((Object)new SnmpTrapType(enterprise, vars, desc, ref));
        return node;
    }

    protected Node exitSnmpTextualConventionMacroType(Production node) throws ParseException {
        String display = null;
        SnmpStatus status = null;
        String desc = null;
        String ref = null;
        MibType syntax = null;
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2113: {
                    display = this.getStringValue(child, 0);
                    break;
                }
                case 2099: {
                    status = (SnmpStatus)this.getValue(child, 0);
                    break;
                }
                case 2097: {
                    desc = this.getStringValue(child, 0);
                    break;
                }
                case 2100: {
                    ref = this.getStringValue(child, 0);
                    break;
                }
                case 2101: {
                    syntax = (MibType)this.getValue(child, 0);
                }
            }
            ++i;
        }
        node.addValue((Object)new SnmpTextualConvention(display, status, desc, ref, syntax));
        return node;
    }

    protected Node exitSnmpObjectGroupMacroType(Production node) throws ParseException {
        ArrayList objects = (ArrayList)this.getValue(this.getChildAt((Node)node, 1), 0);
        SnmpStatus status = (SnmpStatus)this.getValue(this.getChildAt((Node)node, 2), 0);
        String desc = this.getStringValue(this.getChildAt((Node)node, 3), 0);
        String ref = node.getChildCount() <= 4 ? null : this.getStringValue(this.getChildAt((Node)node, 4), 0);
        node.addValue((Object)new SnmpObjectGroup(objects, status, desc, ref));
        return node;
    }

    protected Node exitSnmpNotificationGroupMacroType(Production node) throws ParseException {
        ArrayList notifications = this.getChildAt((Node)node, 1).getAllValues();
        SnmpStatus status = (SnmpStatus)this.getValue(this.getChildAt((Node)node, 2), 0);
        String desc = this.getStringValue(this.getChildAt((Node)node, 3), 0);
        String ref = node.getChildCount() <= 4 ? null : this.getStringValue(this.getChildAt((Node)node, 4), 0);
        node.addValue((Object)new SnmpNotificationGroup(notifications, status, desc, ref));
        return node;
    }

    protected Node exitSnmpModuleComplianceMacroType(Production node) throws ParseException {
        SnmpStatus status = null;
        String desc = null;
        String ref = null;
        ArrayList<Object> modules = new ArrayList<Object>();
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2099: {
                    status = (SnmpStatus)this.getValue(child, 0);
                    break;
                }
                case 2097: {
                    desc = this.getStringValue(child, 0);
                    break;
                }
                case 2100: {
                    ref = this.getStringValue(child, 0);
                    break;
                }
                case 2115: {
                    modules.add(this.getValue(child, 0));
                }
            }
            ++i;
        }
        node.addValue((Object)new SnmpModuleCompliance(status, desc, ref, modules));
        return node;
    }

    protected Node exitSnmpAgentCapabilitiesMacroType(Production node) throws ParseException {
        String prod = null;
        SnmpStatus status = null;
        String desc = null;
        String ref = null;
        ArrayList<Object> modules = new ArrayList<Object>();
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2122: {
                    prod = this.getStringValue(child, 0);
                    break;
                }
                case 2099: {
                    status = (SnmpStatus)this.getValue(child, 0);
                    break;
                }
                case 2097: {
                    desc = this.getStringValue(child, 0);
                    break;
                }
                case 2100: {
                    ref = this.getStringValue(child, 0);
                    break;
                }
                case 2123: {
                    modules.add(this.getValue(child, 0));
                }
            }
            ++i;
        }
        node.addValue((Object)new SnmpAgentCapabilities(prod, status, desc, ref, modules));
        return node;
    }

    protected Node exitSnmpUpdatePart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpOrganizationPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpContactPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpDescrPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpRevisionPart(Production node) throws ParseException {
        MibValue value = (MibValue)this.getValue(this.getChildAt((Node)node, 1), 0);
        String desc = this.getStringValue(this.getChildAt((Node)node, 3), 0);
        node.addValue((Object)new SnmpRevision(value, desc));
        return node;
    }

    protected Node exitSnmpStatusPart(Production node) throws ParseException {
        Node child = this.getChildAt((Node)node, 1);
        String name = this.getStringValue(child, 0);
        if (name.equals("mandatory")) {
            node.addValue((Object)SnmpStatus.MANDATORY);
        } else if (name.equals("optional")) {
            node.addValue((Object)SnmpStatus.OPTIONAL);
        } else if (name.equals("current")) {
            node.addValue((Object)SnmpStatus.CURRENT);
        } else if (name.equals("deprecated")) {
            node.addValue((Object)SnmpStatus.DEPRECATED);
        } else if (name.equals("obsolete")) {
            node.addValue((Object)SnmpStatus.OBSOLETE);
        } else {
            node.addValue((Object)SnmpStatus.CURRENT);
            throw new ParseException(6, "unrecognized status value: '" + name + "'", child.getStartLine(), child.getStartColumn());
        }
        return node;
    }

    protected Node exitSnmpReferPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpSyntaxPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpUnitsPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpAccessPart(Production node) throws ParseException {
        Node child = this.getChildAt((Node)node, 1);
        String name = this.getStringValue(child, 0);
        if (name.equals("not-implemented")) {
            node.addValue((Object)SnmpAccess.NOT_IMPLEMENTED);
        } else if (name.equals("not-accessible")) {
            node.addValue((Object)SnmpAccess.NOT_ACCESSIBLE);
        } else if (name.equals("accessible-for-notify")) {
            node.addValue((Object)SnmpAccess.ACCESSIBLE_FOR_NOTIFY);
        } else if (name.equals("read-only")) {
            node.addValue((Object)SnmpAccess.READ_ONLY);
        } else if (name.equals("read-write")) {
            node.addValue((Object)SnmpAccess.READ_WRITE);
        } else if (name.equals("read-create")) {
            node.addValue((Object)SnmpAccess.READ_CREATE);
        } else if (name.equals("write-only")) {
            node.addValue((Object)SnmpAccess.WRITE_ONLY);
        } else {
            node.addValue((Object)SnmpAccess.READ_WRITE);
            throw new ParseException(6, "unrecognized access value: '" + name + "'", child.getStartLine(), child.getStartColumn());
        }
        return node;
    }

    protected Node exitSnmpIndexPart(Production node) throws ParseException {
        if (this.getChildAt((Node)node, 0).getId() == 1084) {
            node.addValue((Object)this.getChildValues((Node)node));
        } else {
            node.addValues(this.getChildValues((Node)node));
        }
        return node;
    }

    protected Node exitIndexValueList(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitIndexValue(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitIndexType(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpDefValPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpObjectsPart(Production node) {
        node.addValue((Object)this.getChildValues((Node)node));
        return node;
    }

    protected Node exitValueList(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpEnterprisePart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpVarPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpDisplayPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpNotificationsPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpModulePart(Production node) throws ParseException {
        String module = null;
        ArrayList groups = new ArrayList();
        ArrayList<Object> modules = new ArrayList<Object>();
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2116: {
                    module = this.getStringValue(child, 0);
                    this.popContext();
                    break;
                }
                case 2117: {
                    groups = (ArrayList)this.getValue(child, 0);
                    break;
                }
                case 2118: {
                    modules.add(this.getValue(child, 0));
                }
            }
            ++i;
        }
        node.addValue((Object)new SnmpModule(module, groups, modules));
        return node;
    }

    protected Node exitSnmpModuleImport(Production node) throws ParseException {
        String module = this.getStringValue(this.getChildAt((Node)node, 0), 0);
        try {
            this.mib.getLoader().scheduleLoad(module);
        }
        catch (FileNotFoundException e) {
            throw new ParseException(6, "couldn't find referenced MIB: " + module, node.getStartLine(), node.getStartColumn());
        }
        MibReference ref = new MibReference(this.mib.getLoader(), this.getLocation((Node)node), module, null);
        this.mib.addImport(ref);
        this.pushContextExtension(ref);
        node.addValue((Object)module);
        return node;
    }

    protected Node exitSnmpMandatoryPart(Production node) {
        node.addValue((Object)this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpCompliancePart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitComplianceGroup(Production node) throws ParseException {
        MibValue value = (MibValue)this.getValue(this.getChildAt((Node)node, 1), 0);
        String desc = this.getStringValue(this.getChildAt((Node)node, 2), 0);
        node.addValue((Object)new SnmpCompliance(value, null, null, null, desc));
        return node;
    }

    protected Node exitComplianceObject(Production node) throws ParseException {
        MibValue value = null;
        MibType syntax = null;
        MibType write = null;
        SnmpAccess access = null;
        String desc = null;
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2065: {
                    value = (MibValue)this.getValue(child, 0);
                    break;
                }
                case 2101: {
                    syntax = (MibType)this.getValue(child, 0);
                    break;
                }
                case 2121: {
                    write = (MibType)this.getValue(child, 0);
                    break;
                }
                case 2103: {
                    access = (SnmpAccess)this.getValue(child, 0);
                    break;
                }
                case 2097: {
                    desc = this.getStringValue(child, 0);
                }
            }
            ++i;
        }
        node.addValue((Object)new SnmpCompliance(value, syntax, write, access, desc));
        return node;
    }

    protected Node exitSnmpWriteSyntaxPart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpProductReleasePart(Production node) {
        node.addValues(this.getChildValues((Node)node));
        return node;
    }

    protected Node exitSnmpModuleSupportPart(Production node) throws ParseException {
        String module = null;
        ArrayList groups = null;
        ArrayList<Object> vars = new ArrayList<Object>();
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2116: {
                    module = this.getStringValue(child, 0);
                    this.popContext();
                    break;
                }
                case 2110: {
                    groups = child.getAllValues();
                    break;
                }
                case 2124: {
                    vars.add(this.getValue(child, 0));
                }
            }
            ++i;
        }
        node.addValue((Object)new SnmpModuleSupport(module, groups, vars));
        return node;
    }

    protected void childSnmpVariationPart(Production node, Node child) throws ParseException {
        MibType type;
        if (child.getId() == 2065) {
            this.pushContext(this.baseContext);
        } else if (child.getId() == 2101 && (type = (MibType)this.getValue(child, 0)) instanceof MibContext) {
            this.pushContextExtension((MibContext)((Object)type));
        }
        node.addChild(child);
    }

    protected Node exitSnmpVariationPart(Production node) throws ParseException {
        MibValue value = null;
        MibType syntax = null;
        MibType write = null;
        SnmpAccess access = null;
        ArrayList reqs = new ArrayList();
        MibValue defVal = null;
        String desc = null;
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2065: {
                    value = (MibValue)this.getValue(child, 0);
                    this.popContext();
                    break;
                }
                case 2101: {
                    syntax = (MibType)this.getValue(child, 0);
                    if (!(syntax instanceof MibContext)) break;
                    this.popContext();
                    break;
                }
                case 2121: {
                    write = (MibType)this.getValue(child, 0);
                    break;
                }
                case 2103: {
                    access = (SnmpAccess)this.getValue(child, 0);
                    break;
                }
                case 2125: {
                    reqs = (ArrayList)this.getValue(child, 0);
                    break;
                }
                case 2108: {
                    defVal = (MibValue)this.getValue(child, 0);
                    break;
                }
                case 2097: {
                    desc = this.getStringValue(child, 0);
                }
            }
            ++i;
        }
        node.addValue((Object)new SnmpVariation(value, syntax, write, access, reqs, defVal, desc));
        return node;
    }

    protected Node exitSnmpCreationPart(Production node) {
        node.addValue((Object)this.getChildValues((Node)node));
        return node;
    }

    private boolean isBitValue(Node node) {
        if (node.getId() == 1004) {
            return true;
        }
        if (node.getId() == 2078 && node.getChildCount() < 4) {
            return true;
        }
        int i = 0;
        while (i < node.getChildCount()) {
            if (this.isBitValue(node.getChildAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ArrayList getChildValues(Node node) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChildAt(i);
            ArrayList values = child.getAllValues();
            if (values != null) {
                result.addAll(values);
            }
            ++i;
        }
        return result;
    }

    private FileLocation getLocation(Node node) {
        return new FileLocation(this.mib.getFile(), node.getStartLine(), node.getStartColumn());
    }

    private MibContext getContext() {
        return (MibContext)this.contextStack.get(this.contextStack.size() - 1);
    }

    private void pushContext(MibContext context) {
        this.contextStack.add(context);
    }

    private void pushContextExtension(MibContext context) {
        this.pushContext(new CompoundContext(context, this.getContext()));
    }

    private void popContext() {
        this.contextStack.remove(this.contextStack.size() - 1);
    }
}

