#!/bin/bash
#=======================================================================
# * Project: MediaTex
# * Module : script libs
# *
# * Unit test functions
# * 
# * Note: need to use '/' for jails, so differ from utmediatex.sh
#
# MediaTex is an Electronic Records Management System
# Copyright (C) 2014 2015 2016 2017 Nicolas Roche
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#=======================================================================

# includes
[ -z $srcdir ] && srcdir=.
[ -z $libdir ] && libdir=$srcdir/../scripts/lib
[ ! -z $MDTX_SH_INCLUDE ] || source $libdir/include.sh

# this function populate fake DATADIR used for unit tests
function UNIT_TEST_populate_datadir()
{
    mkdir -p $MISC
    mkdir -p $SCRIPTS

    for f in cron mediatex.conf supports.txt logo \
	catalog000.txt extract000.txt servers.txt htgroup \
	mediatex.css floppy-icon.png apache-mdtx.conf put.sh; do
	install -o root -g root -m 444 $srcdir/../misc/$f $MISC
    done
    for t in home index cache score cgi; do
	install -o root -g root -m 444 $srcdir/../misc/$t.htaccess $MISC
    done
    install -o root -g root -m 444 $srcdir/../scripts/mediatexd1 $SCRIPTS
    install -o root -g root -m 444 $srcdir/../scripts/mediatexd2 $SCRIPTS

    # Note:
    #  Jail dir must be owned by root and not writable by others users,
    #  both conditions must be recursively applied from / dir.
    mkdir -p $UNIT_TEST_ROOTDIR
    chmod 755 $UNIT_TEST_ROOTDIR

    #mkdir -p $ETCDIR # TO MOVE !!
    mkdir -p $SYSCONFDIR/apache2/conf-available
    mkdir -p $SYSCONFDIR/cron.d
    mkdir -p $SYSCONFDIR/logrotate.d/httpd-prerotate
    mkdir -p $SYSCONFDIR/init.d
}

# this function set the directory to use for unit tests. 
# $1: UNIT_TEST_ROOTDIR
function UNIT_TEST_push_root_directory()
{
    if [ $# -ne 1 ]; then
	echo "expect 1 parameter"
	exit 1;
    fi

    # path configuration variables for unit tests: 
    #  we use "/tmp/ut-XXX" to prefix all paths
    
    # overwrite global variables
    BINDIR="${1}/usr/bin"
    DATAROOTDIR="${1}/usr/share"
    EXEC_PREFIX="${1}/usr"
    LIBDIR="${1}/usr/lib"
    LOCALSTATEDIR="${1}/var"
    PREFIX="${1}/usr"
    SYSCONFDIR="${1}/etc"

    # overwrite scripts variables
    ETCDIR="${SYSCONFDIR}${MEDIATEX}"
    DATADIR="${DATAROOTDIR}${MEDIATEX}"
    STATEDIR="${LOCALSTATEDIR}/lib${MEDIATEX}"
    CACHEDIR="${LOCALSTATEDIR}/cache${MEDIATEX}"
    PIDDIR="${LOCALSTATEDIR}/run${MEDIATEX}"
    SCRIPTS="${DATADIR}/scripts"
    MISC="${DATADIR}/misc"
    HOSTSSH="${SYSCONFDIR}/ssh"

    # overwrite recurent variables
    GITBARE="${STATEDIR}/$MDTX"
    MDTXHOME="${CACHEDIR}/$MDTX"
    MD5SUMS="${MDTXHOME}${CONF_MD5SUMS}"
    CACHES="${MDTXHOME}${CONF_CACHES}"
    EXTRACT="${MDTXHOME}${CONF_EXTRACT}"
    GITCLT="${MDTXHOME}${CONF_GITCLT}"
    JAIL="${MDTXHOME}${CONF_JAIL}"
    HOMES="${MDTXHOME}${CONF_HOME}"
    MDTXGIT="${GITCLT}/$MDTX"
    CONFFILE="${MDTXGIT}/$MDTX${CONF_CONFFILE}"
    PIDFILE="${PIDDIR}/$MDTX${CONF_PIDFILE}"

    if [ $(id -u) -eq 0 ]; then
	UNIT_TEST_populate_datadir
    fi
}

# so as to pass unit test easier
# $1: out file to sed
function UNIT_TEST_mrProper()
{
    # hide line numbers
    sed $1 -i -e "s,^\(\[.*\):.*\],\1],"

    # hide base directories path
    sed $1 -i -e "s,/var/ut/ut[0-9]-mdtx,,g"

	# -e "s,$SYSCONFDIR,SYSCONFDIR,g" \
	# -e "s,$LOCALSTATEDIR,LOCALSTATEDIR,g" \
	# -e "s,$DATAROOTDIR,DATAROOTDIR,g" \
	# -e "s,$BINDIR,BINDIR,g" \
	# -e "s,$EXEC_PREFIX,EXEC_PREFIX,g" \
	# -e "s,$PREFIX,PREFIX,g"

    # hide user and group numbers
    sed $1 -i -e "s,^\(.*:x:\).*:,\1XXX:,"

    # hide group number
    sed $1 -i -e "s,:x:[[:digit:]]*:,:x:XXX:,"
    
    # hide git commit date and id
    sed $1 -i \
	-e "s,^\(Date:  \).*,\1 XXX," \
	-e "s,^   [^ ]* \( master -> master\),   XXX..XXX \1," \
	-e "s,^\(commit\).*,\1 XXX," \
	-e "s,^\(\[master (commit racine) \)[^]]*,\1 XXX," \
	-e "s,^\(\[master \)[^]]*,\1 XXX,"
	
    # [master (commit racine) 1d93f9d]
    # [master 637f68c]
    # 1d93f9d..df4c07b  master -> master
    # commit df4c07b96124d2ddd73f6fd19edd7d42aa64e013
    # Date:   Sat Apr 23 23:47:39 2016 +0200
    
    # hide i386/amd64 defferences
    sed $1 -i -e "/^lib64$/ d"

    # hide default SSH port
    sed $1 -i -e "s,\(localhost\) $SSH_PORT,\1 22,"

    # hide git id and versions differences
    sed $1 -i -e "s,[0-9a-f]\{40\},XXXX,"
    sed $1 -i -e "s,[0-9]* \(files changed\),XX \1,"
    sed $1 -i -e "s,To ssh://ut4-mdtx-hello@localhost,To ssh://localhost,"
}

# this function switch on into the unit test mode
# $1 the related module file name
# return 1 if not called by the module
function UNIT_TEST_start()
{
    [ -z $1 ] && echo "Please provide module file name"

    # this return when module is sourced
    [ $(basename "$0") = "ut$1.sh" ] || return 1
    UNIT_TEST_RUNNING=1

    # log to stderr for tests
    LOG_FACILITY=file
    LOG_SEVERITY=debug
    export LANG=C

    # root directory for tests requiering root user (jails...)
    UNIT_TEST_ROOTDIR="/var/ut/$MDTX"
    UNIT_TEST_push_root_directory $UNIT_TEST_ROOTDIR

    # backup stdout and stderr values
    exec 3>&1 4>&2
    
    # redirect outputs to a file
    exec >scripts/$1.out 2>&1
}

# this function switch on into the unit test mode
# $1 the module file name provided by the caller
function UNIT_TEST_stop()
{
    [ -z $1 ] && echo "Please provide module file name"

    # flush output file (not needed)
    exec >&- 2>&-

    # retrieve the originals outputs
    exec >&3 2>&4

    # compare with the expected output
    UNIT_TEST_EXPECTED="$srcdir/scripts/${1}.exp"
    [ -f $UNIT_TEST_EXPECTED ] || UNIT_TEST_EXPECTED="/dev/null"
    
    UNIT_TEST_mrProper scripts/$1.out
    diff -I known_hosts $UNIT_TEST_EXPECTED scripts/$1.out

    # only needed for check_as_root
    if [ $(id -u) -eq 0 ]; then
	rm -fr /var/ut
    fi
}
