/*=======================================================================
 * Version: $$
 * Project: MediaTeX
 * Module : misc for seda02
 *
 * common functions

 MediaTex is an Electronic Records Management System
 Copyright (C) 2016  Nicolas Roche
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 =======================================================================*/

#include "mediatex.h"
#include <openssl/sha.h>

#define MAX_SIZE_SHA1 40

int getArchiveIds(char* path, char* hash, off_t* size);
char* sha1sum2string(unsigned char sha1sum[SHA_DIGEST_LENGTH], 
		     char rc[MAX_SIZE_SHA1 + 1]);
int computeSha1(char* path, off_t size, char checksum[MAX_SIZE_SHA1 + 1]);
