#!/usr/bin/perl
#=======================================================================
# * Version: $Id: search.cgi,v 1.1.1.1 2015/05/31 14:39:44 nroche Exp $
# * Project: MediaTex
# * Module : Reversibility use case
# *
# * This cgi-script provide a multiple entry form 
#
# MediaTex is an Electronic Records Management System
# Copyright (C) 2016  Nicolas Roche
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#=======================================================================

use utf8;
use CGI;
use DBI;

$html = CGI->new; # create new CGI object
print $html->header, # create the HTTP header
    $html->start_html('Multi-criteria search'), # start the HTML
    $html->h1('Multi-criteria searc'), # level 1 header
    $html->end_html; # end the HTML

$limit = 10;
$host = "https://localhost/";
$famname=$html->param('famname');
$persname=$html->param('persname');
$numavis=$html->param('numavis');
$numloc=$html->param('numloc');
$numint=$html->param('numint');
$annee=$html->param('annee');
$mois=$html->param('mois');
$page = $html->param('page');
$debug=0;

#########################################################################
$uri="search.cgi";
$filename = '/etc/mediatex/credentials.sh';
#print "credentials -> $filename<br>\n";

if (!open($fh, $filename)) {
    print "Cannot open file: $filename<BR>\n";
    exit;
}

while (my $row = <$fh>) {
    $row =~ /(.*)=(.*)$/;
    $key = $1;
    $value = $2;

    if ($key eq 'DB_BASE') {
	$dbname = $value;
    }
    if ($key eq 'DB_HOST') {
	$dbhost = $value;
    }
    if ($key eq 'DB_PORT') {
	$dbport = $value;
    }
    if ($key eq 'DB_USER') {
	$dbuser = $value;
    }
    if ($key eq 'DB_PASSWD') {
	$dbpasswd = $value;
    }
    if ($key eq 'TABLE') {
	$table = $value;
    }
    #print "$row : $key -> $value\n<br>";
}

if (!(defined($dbname))) {
    $msg = "No DB_NAME";
}
if (!(defined($dbhost))) {
    $msg = "No DB_HOST";
}
if (!(defined($dbport))) {
    $msg = "No DB_PORT";
}
if (!(defined($dbuser))) {
    $msg = "No DB_USER";
}
if (!(defined($dbpasswd))) {
    $msg = "No DB_PASSWD";
}
if (!(defined($table))) {
    $msg = "No TABLE";
}
if (defined($msg)) {
    print "Configuration error: $msg<BR>\n";
    exit;
}
#########################################################################

# field as paramter 0
# fild name to display as parameter 1
sub formColumn{
    my @array;

    $query="SELECT distinct ".$_[0]." FROM ".$table.
	" ORDER BY ".$_[0]." ASC;";

    if ($debug == 1) {
	print "<PRE>".$query."</PRE>";
    }

    $cursor = $dbh->prepare($query); 
    $cursor->execute;

    print "<TR>\n";
    print "<TD>$_[1]</TD>";
    print "<TD><SELECT NAME='$_[0]' VALUE='$val'>\n";
    print "<OPTION>\n";

    while ( @row = $cursor->fetchrow ) {
	$val=$html->param($_[0]);

	if ($row[0] eq $val) {
	    print "<OPTION selected>$row[0]\n";
	}
	else {
	    print "<OPTION>$row[0]\n";
	}
    }
    print "</SELECT></TD>\n";
    print "</TR>\n";
}

# display page counter
sub showPages{
    printf "<P>pages : %i ", $nb;
    $url= $html->self_url(-relative=>1);
    if ($page > 0) {
	$p = $page - 1;
	$url =~ s/page=.*/page=$p/;
	printf "<A href='%s'><</A>", $url;
    }
    else {
	print "<";
    }
    printf " %i/%i ", $page+1, $nb/$limit+1;
    $url= $html->self_url(-relative=>1);
    if ($page < int($nb/$limit)) {
	$p = $page + 1;
	$url =~ s/page=.*/page=$p/;
	printf "<A href='%s'>></A>", $url;
    }
    else {
	print ">";
    }
    print "</P>";
}

# connect DB
if (!($dbh = DBI->connect(
    "dbi:Pg:dbname=$dbname;host=$dbhost;port=$dbport", $dbuser, $dbpasswd
    ))) {
    printf "Database error: ".$DBI::errstr;
    exit;
}

# display formulary
print "<FORM ACTION='$uri' METHOD='GET'>\n";
print "<TABLE></HR>\n";
print "<TR><TD><HR></TD><TD><HR></TD></TR>\n";
print "<TR><TD>Nom</TD><TD><INPUT NAME='persname' VALUE='".
    $persname."'></TD></TR>\n";
print "<TR><TD>Prénom</TD><TD><INPUT NAME='famname' VALUE='".
    $famname."'></TD></TR>\n";
print "<TR><TD>Numéro avis</TD><TD><INPUT NAME='numavis' VALUE='".
    $numavis."'></TD></TR>\n";
print "<TR><TD>Numéro locataire</TD><TD><INPUT NAME='numloc' VALUE='".
    $numloc."'></TD></TR>\n";
print "<TR><TD>Numéro int</TD><TD><INPUT NAME='numint' VALUE='".
    $numint."'></TD></TR>\n";

formColumn("annee", "Année");
formColumn("mois", "Mois");

print "<TR><TD></TD><TD><INPUT HIDDEN NAME='page' VALUE='0'></TD></TR>\n";
print "<TR><TD><HR></TD><TD><HR></TD></TR>\n";
print "<TR><TD><INPUT TYPE=submit VALUE='Chercher'></TD>\n";
print "<TD><INPUT TYPE='button' VALUE='Annuler' ".
    "onclick='location.href=\"search.cgi\"'></TD></TR>\n";
print "<TR><TD><HR></TD><TD><HR></TD></TR>\n";
print "</TABLE>\n";
print "</FORM>\n";

if (defined($page)) {
    # build queries
    $query='';
    $count="SELECT count(*)";
    $select="SELECT title, file, urlData, urlMetadata";

    # common part
    $query=$query.
	" FROM ".$table;
    $query=$query.
	" WHERE 1=1";
    if (!($famname eq '')) {
	$query=$query." AND famname ILIKE '%".$famname."%'";
    }
    if (!($persname eq '')) {
	$query=$query." AND persname ILIKE '%".$persname."%'";
    }
    if (!($numavis eq '')) {
	$query=$query." AND numavis = ".$numavis;
    }
    if (!($numloc eq '')) {
	$query=$query." AND numloc = ".$numloc;
    }
    if (!($numint eq '')) {
	$query=$query." AND numint = ".$numint;
    }
    if (!($annee eq '')) {
	$query=$query." AND annee = ".$annee;
    }
    if (!($mois eq '')) {
	$query=$query." AND mois = ".$mois;
    }

    # assembling queries
    $count=$count.$query;
    $select=$select.$query." ORDER BY title";
    $select=$select." ASC LIMIT ".$limit." OFFSET ".$page*$limit;

    if ($debug == 1) {
	print "<PRE>".$count.";<BR>";
	print $select.";</PRE>";
    }

    # run count query
    $cursor = $dbh->prepare($count);
    $cursor->execute;
    @row = $cursor->fetchrow;
    $nb =  $row[0];

    # run select query
    $cursor = $dbh->prepare($select);
    $cursor->execute;

    # display results
    showPages();
    print "<TABLE BORDER=1>\n";
    print "<TR>\n";
    printf "<TD>Titre</TD><TD>Infos</TD><TD>Télécharger</TD>";
    print "</TR>\n";

    while ( @row = $cursor->fetchrow ) {
    	print "<TR>\n";
    	printf "<TD>%s</TD>", $row[0];
	printf "<TD><A href='%s%s'>%s</A></TD>", $host, $row[3], "...";
	printf "<TD><A href='%s%s'>%s</A></TD>\n", $host, $row[2], $row[1]; 
    	print "</TR>\n";
    }
    print "</TABLE>\n";

    $cursor->finish;
    $dbh->disconnect;
    showPages();
}

print "</BODY>\n";
print "</HTML>\n";
exit;
