/*=======================================================================
 * Project: SCOREDIT
 * Module : ardsm
 *
 * Abstract Ring Data Structure Management interface.
 * This file was originally written by Peter Felecan under GNU GPL

 MediaTex is an Electronic Records Management System
 Copyright (C) 2014  Felecan Peter
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
=======================================================================*/

#ifndef MDTX_MEMORY_ARDSM_H
#define MDTX_MEMORY_ARDSM_H 1

typedef struct RGIT
{   /*  RinG ITem : */
    struct RGIT* next;
    struct RGIT* prev;

    void* it;   /*  : ring's item content   */
} RGIT;

typedef struct RG
{   /*  RinG :  */
  RGIT* head;
  RGIT* curr;
  RGIT* tail;
  int nbItems;
} RG;

/* void* rgNext_r(RG* ring, RGIT** curr) provided as a macro */
#define rgNext_r(ring, curr)				\
(ring->head?						\
 ((*curr = (*curr) ? (*curr)->next : ring->head)?	\
  (*curr)->it : 0) : 0)

/* RGIT* rgHaveItem(RG* ring, void* pItem) provided as a macro */
#define rgHaveItem(ring, pItem)					\
  ({								\
    RGIT* rc = 0;						\
    void* pIt = 0;						\
    while ((pIt = rgNext_r(ring, &rc)) && pIt != pItem);	\
    rc;								\
  })

RGIT* rgCreate(void);
void rgDestroy(RGIT* item);
void rgInit(RG* ring);
void rgDelete(RG* ring);
int rgInsert(RG* ring, void *item);
int rgInsert_r(RG* ring, void *item, RGIT** curr);
int rgHeadInsert(RG* ring, void* it);
void rgRemove(RG* ring);
void rgRemove_r(RG* ring, RGIT** curr);
void* rgCurrent(RG* ring);
void* rgPrevious(RG* ring);
void* rgNext(RG* ring);
void* rgHead(RG* ring);
void rgRewind(RG* ring);
int rgSort(RG* ring, int(*compar)(const void *, const void *));
RGIT* rgMatchItem(RG* ring, void* pItem, 
		  int(*compar)(const void *, const void *));
int rgDelItem(RG* ring, void* pItem);
int rgShareItems(RG* ring1, RG* ring2);
RG* rgInter(RG* ring1, RG* ring2);
RG* rgUnion(RG* ring1, RG* ring2);
RG* rgMinus(RG* ring1, RG* ring2);
int cmpPtr(const void *p1, const void *p2);

RG* createRing(void);
RG* destroyOnlyRing(RG* self);
RG* destroyRing(RG* self, void*(*destroyItem)(void*));
RG* copyRing(RG* destination, RG* source, 
	     void* (*destroyItem)(void*),
	     void* (*copyItem)(void*, const void*));
inline int isEmptyRing(RG* self);

#endif /* MDTX_MEMORY_ARDSM_H */

/* Local Variables: */
/* mode: c */
/* mode: font-lock */
/* End: */
