/*=======================================================================
 * Version: $Id: seda02.y,v 1.1.1.1 2015/05/31 14:39:44 nroche Exp $
 * Project: MediaTeX
 * Module : XML parser for a seda v0.2 example
 *
 * Bison push parser to be used by Sax

 MediaTex is an Electronic Records Management System
 Copyright (C) 2016  Nicolas Roche
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 =======================================================================*/

/* prologue: =======================================================*/
%{

  /*
#include "mediatex.h"
#include "misc/log.h"
  */
#include "misc.h"
#include "memory/archive.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "misc.h"
%}

%code provides {
  typedef struct BisonData {
    // input data
    char* basename;
    Collection* coll;
    //Archive* xmlSedaFile;
    Container* zipSedaFile;

    // working data
    Category* profile;
    Document* transfer;
    Document* document;
    Archive* archive;
    Role* locataire;
    Role* transferringAgency;
    Role* archivalAgency;
    char name1[256];
    char name2[256];
  } BisonData;

  void seda_error(void* data, const char* message);
  void* createParser (void);
  void pushParser (void* ps, int lexem, SEDA_STYPE* value, BisonData* data);
  void destroyParser (void* ps);
  //char* addBasename(BisonData* data, char* path);
}

%{
#define DATA ((BisonData*)data)
#define ERROR seda_error(data, "error while building tree");
%}

/* declarations: ===================================================*/

%defines "seda02.h"
%output  "seda02.c"
%define api.prefix {seda_}
%define api.pure
%define api.push-pull push
%parse-param {void* data} // BisonData
%error-verbose
%verbose
%debug

 // YYSTYPE (alias SEDA_STYPE)
%union {
  char string[256];
}

%token <string> TEXT
%token <string> ATTR_XMLNS
%token <string> ATTR_ALGORITHME
%token <string> ATTR_LISTVERSIONID
%token <string> ATTR_FILENAME

%token          _ARCHIVETRANSFER
%token           ARCHIVETRANSFER_
%token          _COMMENT
%token           COMMENT_
%token          _DATE
%token           DATE_
%token          _TRANSFERTIDENTIFIER
%token           TRANSFERTIDENTIFIER_
%token          _IDENTIFICATION
%token          IDENTIFICATION_
%token          _TRANSFERRINGAGENCY
%token           TRANSFERRINGAGENCY_
%token          _ARCHIVALAGENCY
%token           ARCHIVALAGENCY_
%token           INTEGRITY_
%token          _INTEGRITY
%token          _CONTAINS
%token           CONTAINS_
%token          _UNITIDENTIFIER
%token           UNITIDENTIFIER_
%token          _ARCHIVALAGREEMENT
%token           ARCHIVALAGREEMENT_
%token          _ARCHIVALPROFILE
%token           ARCHIVALPROFILE_	    
%token          _DESCRIPTIONLANGUAGE
%token           DESCRIPTIONLANGUAGE_
%token          _DESCRIPTIONLEVEL
%token           DESCRIPTIONLEVEL_   
%token          _NAME
%token           NAME_		    
%token          _CONTENTDESCRIPTION
%token           CONTENTDESCRIPTION_ 
%token          _DESCRIPTION
%token           DESCRIPTION_	    
%token          _FORMAT
%token           FORMAT_	    
%token          _LANGUAGE
%token           LANGUAGE_	    
%token          _ORIGINATINGAGENCY
%token           ORIGINATINGAGENCY_ 
%token          _CONTENTDESCRIPTIVE
%token           CONTENTDESCRIPTIVE_ 
%token          _KEYWORDCONTENT
%token           KEYWORDCONTENT_    
%token          _KEYWORDTYPE
%token           KEYWORDTYPE_	    
%token          _APPRAISAL
%token           APPRAISAL_	    
%token          _CODE
%token           CODE_		    
%token          _DURATION
%token           DURATION_	    
%token          _STARTDATE
%token           STARTDATE_	    
%token          _ACCESSRESTRICTION
%token           ACCESSRESTRICTION_  
%token          _DOCUMENT
%token           DOCUMENT_	    
%token          _ATTACHMENT
%token           ATTACHMENT_	    
%token          _CONTROL
%token           CONTROL_		    
%token          _COPY
%token           COPY_		    
%token          _ISSUE
%token           ISSUE_
%token          _PURPOSE
%token           PURPOSE_
%token          _TYPE
%token           TYPE_               

%type  <string> Identification
%type  <string> Description
%type  <string> Contains1
%type  <string> UnitIdentifier
%type  <string> Comment
%type  <string> Date
%type  <string> ArchivalAgreement
%type  <string> DescriptionLanguage
%type  <string> DescriptionLevel
%type  <string> Name
%type  <string> Format
%type  <string> Language
%type  <string> OriginatingAgency
%type  <string> KeywordContent 
%type  <string> KeywordType
%type  <string> Code
%type  <string> Duration
%type  <string> StartDate
%type  <string> Control
%type  <string> Copy
%type  <string> Issue
%type  <string> Purpose
%type  <string> Type

%start ArchiveTransfer

%%

/* grammar rules: ==================================================*/

ArchiveTransfer: _ARCHIVETRANSFER ATTR_XMLNS transfer ARCHIVETRANSFER_

transfer: Comment Date TransferIdentifier TransferringAgency ArchivalAgency integrities contains2
{
  Carac* carac = 0;

  if (!(carac = addCarac(DATA->coll, "Comment"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->transfer, $1)) ERROR;
  if (!(carac = addCarac(DATA->coll, "Date"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->transfer, $2)) ERROR;
}

Comment: _COMMENT TEXT COMMENT_
{
  logParser(LOG_INFO, " comment: %s",$2);
  strncpy($$, $2, 255);
}

Date: _DATE TEXT DATE_
{
  logParser(LOG_INFO, " date: %s",$2);
  strncpy($$, $2, 255);
}

TransferIdentifier: _TRANSFERTIDENTIFIER TEXT TRANSFERTIDENTIFIER_
{
  logParser(LOG_INFO, " transfertIdentifier: %s",$2);

  if (!(DATA->transfer = addDocument(DATA->coll, $2))) ERROR;
}

Identification: _IDENTIFICATION TEXT IDENTIFICATION_
{
  strncpy($$, $2, 255);
}

TransferringAgency: _TRANSFERRINGAGENCY Identification TRANSFERRINGAGENCY_
{
  Human* human = 0;
  logParser(LOG_INFO, " transferringAgency: %s",$2);

  if (!(human = addHuman(DATA->coll, $2, ""))) ERROR;
  if (!addAssoRole(DATA->coll, DATA->transferringAgency, human, 
		   DATA->transfer)) 
    ERROR;
}

ArchivalAgency: _ARCHIVALAGENCY Identification ARCHIVALAGENCY_
{
  Human* human = 0;
  logParser(LOG_INFO, " archivalAgency: %s", $2);

  if (!(human = addHuman(DATA->coll, $2, ""))) ERROR;
  if (!addAssoRole(DATA->coll, DATA->archivalAgency, human, 
		   DATA->transfer))
    ERROR;
}

integrities: integrities Integrity
           | Integrity

Integrity: _INTEGRITY Contains1 UnitIdentifier INTEGRITY_
{
  char sha1sum[MAX_SIZE_SHA1 + 1];
  Carac* carac = 0;
  AssoCarac* assoCarac = 0;

  logParser(LOG_INFO, "%s"," integrity");

  // check SHA1 sum
  if (!computeSha1($3, DATA->archive->size, sha1sum)) ERROR;

  if (strncmp($2, sha1sum, MAX_SIZE_SHA1)) {
    logParser(LOG_ERR, "SHA1 sum mismatch: '%s' expected",$2);
    ERROR;
  }

  // add carac SHA1
  if (!(carac = getCarac(DATA->coll, "sha1"))) ERROR;
  if (!(assoCarac = addAssoCarac(DATA->coll, carac, ARCH, DATA->archive, $2)))
    ERROR;
}

Contains1: _CONTAINS ATTR_ALGORITHME TEXT CONTAINS_
{
  logParser(LOG_INFO, "  algorithme: %s",$2);
  logParser(LOG_INFO, "  contains: %s",$3);

  strncpy($$, $3, 255);
}

UnitIdentifier: _UNITIDENTIFIER TEXT UNITIDENTIFIER_
{
  char* path = 0;
  char hash[MAX_SIZE_MD5+1];
  off_t size = 0;
  logParser(LOG_INFO, "  unitidentifier: %s",$2);

  //path = addBasename(DATA, $2);
  path = $2;

  // build the archive object
  if (!getArchiveIds(path, hash, &size)) ERROR;
  if (!(DATA->archive = addArchive(DATA->coll, hash, size))) ERROR;

  // add an extraction rule from the Seda ZIP file
  if (!(addFromAsso(DATA->coll, DATA->archive, DATA->zipSedaFile, path)))
    ERROR;

  strncpy($$, path, 255);
}

contains2: contains2 Contains2
         | Contains2

Contains2: _CONTAINS content CONTAINS_

content: ArchivalAgreement ArchivalProfile DescriptionLanguage DescriptionLevel Name ContentDescription Appraisal AccessRestriction Document
{
  Carac* carac = 0;
  logParser(LOG_INFO, "%s"," content");

  // will be used by txt2txt to split metadata by contract
  if (!(carac = addCarac(DATA->coll, "Archival Agreement"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $1)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Description Language"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $3)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Description Level"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $4)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Name"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $5)) ERROR;
}

ArchivalAgreement: _ARCHIVALAGREEMENT TEXT ARCHIVALAGREEMENT_
{
  logParser(LOG_INFO, "  ArchivalAgreement: %s",$2);
  strncpy($$, $2, 255);
}

ArchivalProfile: _ARCHIVALPROFILE TEXT ARCHIVALPROFILE_
{
  logParser(LOG_INFO, "   ArchivalProfile: %s",$2);

  // store ArchivalProfile as a category
  if (!(DATA->profile = addCategory(DATA->coll, $2, TRUE))) ERROR;
}

DescriptionLanguage: _DESCRIPTIONLANGUAGE ATTR_LISTVERSIONID TEXT DESCRIPTIONLANGUAGE_
{
  logParser(LOG_INFO, "  listVersionID: %s",$2);
  logParser(LOG_INFO, "  DescriptionLanguage: %s",$3);
  strncpy($$, $3, 255);
}

DescriptionLevel: _DESCRIPTIONLEVEL ATTR_LISTVERSIONID TEXT DESCRIPTIONLEVEL_
{
  logParser(LOG_INFO, "  listVersionID: %s",$2);
  logParser(LOG_INFO, "  DescriptionLevel: %s",$3);
  strncpy($$, $3, 255);
}

Name: _NAME TEXT NAME_
{
  logParser(LOG_INFO, "   Name: %s",$2);
  strncpy($$, $2, 255);

  // create an temporary document as we still don't knows its id
  // true document is build into contentDescription rule
  if (!(DATA->document = createDocument())) ERROR;

  /* // buid the document object */
  /* if (!(DATA->document = addDocument(DATA->coll, $2))) ERROR; */
  /* if (!addDocumentToCategory(DATA->coll, DATA->document, DATA->profile))  */
  /*   ERROR; */
}

ContentDescription: _CONTENTDESCRIPTION contentDescription CONTENTDESCRIPTION_

contentDescription: Description Format Language OriginatingAgency contentDescriptives
{
  Carac* carac = 0;
  Human* human = 0;
  Document* document = 0;

  // buid the true document object
  // no need to set categories to the new docuemnt (no reverse pointers)
  document = DATA->document;  
  if (!(DATA->document = addDocument(DATA->coll, document->label))) ERROR;
  DATA->document->assoCaracs
      = destroyRing(DATA->document->assoCaracs,
		    (void*(*)(void*)) destroyAssoCarac);
  DATA->document->assoCaracs = document->assoCaracs;
  document->label = destroyString(document->label);
  document->assoCaracs = 0;
  document = destroyDocument(document);

  if (!addDocumentToCategory(DATA->coll, DATA->document, DATA->profile))
    ERROR;

  if (!(carac = addCarac(DATA->coll, "Content Description"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $1)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Format"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $2)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Language"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $3)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Originating agency"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $4)) ERROR;

  // persanme and famname store as mediatex human
  if (!(human = addHuman(DATA->coll, DATA->name1, DATA->name2))) ERROR;
  if (!addAssoRole(DATA->coll, getRole(DATA->coll, "Locataire"), 
		   human, DATA->document)) ERROR;
}

Description: _DESCRIPTION TEXT DESCRIPTION_
{
  logParser(LOG_INFO, "    Description: %s",$2);
  strncpy($$, $2, 255);
}

Format: _FORMAT TEXT FORMAT_
{
  logParser(LOG_INFO, "    Format: %s",$2);
  strncpy($$, $2, 255);
}

Language: _LANGUAGE ATTR_LISTVERSIONID TEXT LANGUAGE_
{
  logParser(LOG_INFO, "    Language: %s", $3);
  strncpy($$, $3, 255);  
}

OriginatingAgency: _ORIGINATINGAGENCY Identification ORIGINATINGAGENCY_
{
  logParser(LOG_INFO, "    OriginatingAgency: %s",$2);
  strncpy($$, $2, 255);
}

contentDescriptives: contentDescriptives ContentDescriptive
                   | ContentDescriptive

ContentDescriptive: _CONTENTDESCRIPTIVE contentDescriptive CONTENTDESCRIPTIVE_
{
  logParser(LOG_INFO, "%s","    ContentDescriptive");
}

contentDescriptive: KeywordContent KeywordType
{
  Carac* carac = 0;
  int idValue = 0;
  char idString[16];

  // persname is sometime empty
  if (!strcmp($2, "persname")) {
    strncpy(DATA->name2, $1, 255);
    goto endContentdescriptive;
  }

  if (!*$1) { 
    logParser(LOG_ERR, "empty keyword content fo %s", $2);
    YYABORT;
  }

  // document id
  if (!strcmp($2, "numavis")) {
    // pad 0 on left
    if (sscanf($1, "%i", &idValue) != 1) ERROR;
    if (sprintf(idString, "%08i", idValue) < 1) ERROR;
    if (!(DATA->document->label = createString(idString))) ERROR;
  }

  if (!strcmp($2, "famname")) {
    strncpy(DATA->name1, $1, 255);
    goto endContentdescriptive;
  }

  if (!(carac = addCarac(DATA->coll, $2))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $1)) ERROR;
 endContentdescriptive:
  ;
}

KeywordContent: _KEYWORDCONTENT TEXT KEYWORDCONTENT_
{
  logParser(LOG_INFO, "     KeywordContent: %s",$2);
  strncpy($$, $2, 255);
}
              | _KEYWORDCONTENT KEYWORDCONTENT_
{
  // empty keyword content
  $$[0] = 0;
}

KeywordType: _KEYWORDTYPE ATTR_LISTVERSIONID TEXT KEYWORDTYPE_
{
  logParser(LOG_INFO, "     KeywordType: %s",$3);
  strncpy($$, $3, 255);
}

Appraisal: _APPRAISAL Code Duration StartDate APPRAISAL_
{
  Carac* carac = 0;
  logParser(LOG_INFO, "%s","     Appraisal");

  if (!(carac = addCarac(DATA->coll, "Appraisal Code"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $2)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Appraisal Duration"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $3)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Appraisal Start Date"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $4)) ERROR;
}

AccessRestriction: _ACCESSRESTRICTION Code StartDate ACCESSRESTRICTION_
{
  Carac* carac = 0;
  logParser(LOG_INFO, "%s","     AccessRestriction");

  if (!(carac = addCarac(DATA->coll, "Access Restriction Code"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $2)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Access Restriction Start Date"))) 
    ERROR;
  if (!addAssoCarac(DATA->coll, carac, DOC, DATA->document, $3)) ERROR;
}

Code: _CODE ATTR_LISTVERSIONID TEXT CODE_
{
  logParser(LOG_INFO, "      Code: %s", $3);
  strncpy($$, $3, 255);
}

Duration: _DURATION TEXT DURATION_
{
  logParser(LOG_INFO, "      Duration: %s", $2);
  strncpy($$, $2, 255);
}

StartDate: _STARTDATE TEXT STARTDATE_
{
  logParser(LOG_INFO, "      StartDate: %s", $2);
  strncpy($$, $2, 255);
}

Document: _DOCUMENT document DOCUMENT_
{
  logParser(LOG_INFO, "%s","     Document");
}

// Mediatex Archive
document: Attachment Control Copy Description Issue Purpose Type
{
  Carac* carac = 0;

  if (!addArchiveToDocument(DATA->coll, DATA->archive, DATA->document)) 
    ERROR;

  if (!(carac = addCarac(DATA->coll, "Control"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, ARCH, DATA->archive, $2)) ERROR;

   if (!(carac = addCarac(DATA->coll, "Copy"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, ARCH, DATA->archive, $3)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Description"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, ARCH, DATA->archive, $4)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Issue"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, ARCH, DATA->archive, $5)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Purpose"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, ARCH, DATA->archive, $6)) ERROR;

  if (!(carac = addCarac(DATA->coll, "Type"))) ERROR;
  if (!addAssoCarac(DATA->coll, carac, ARCH, DATA->archive, $7)) ERROR;
}

// archive path once again
Attachment: _ATTACHMENT ATTR_FILENAME ATTACHMENT_
{
  char* path = 0;
  char hash[MAX_SIZE_MD5+1];
  off_t size = 0;
  FromAsso* fromAsso = 0;
  logParser(LOG_INFO, "      Attachment: %s",$2);

  //path = addBasename(DATA, $2);
  path = $2;

  // retrieve the archive having this path (cannot search quicky using it)
  if (!getArchiveIds(path, hash, &size)) ERROR;
  if (!(DATA->archive = getArchive(DATA->coll, hash, size))) ERROR;

  // check the path is the same
  rgRewind(DATA->archive->fromContainers);
  fromAsso = rgNext(DATA->archive->fromContainers);
  if (strncmp(fromAsso->path, path, 255)) {
    logParser(LOG_ERR, "path '%s' mismatch: '%s' expected", path, fromAsso->path);
    ERROR;
  }
}

Control: _CONTROL TEXT CONTROL_
{
  logParser(LOG_INFO, "      Control: %s",$2);
  strncpy($$, $2, 255);
}

Copy:_COPY TEXT COPY_
{
  logParser(LOG_INFO, "      Copy: %s",$2);
  strncpy($$, $2, 255);
}

Issue: _ISSUE TEXT ISSUE_
{
  logParser(LOG_INFO, "      Issue: %s",$2);
  strncpy($$, $2, 255);
}

Purpose: _PURPOSE TEXT PURPOSE_
{
  logParser(LOG_INFO, "      Purpose: %s",$2);
  strncpy($$, $2, 255);
}

Type: _TYPE  ATTR_LISTVERSIONID TEXT TYPE_
{
  logParser(LOG_INFO, "      Type: %s",$3);
  strncpy($$, $3, 255);
}

%%

/* epilogue: =======================================================*/

/* /\*======================================================================= */
/*  * Function   : addBasename */
/*  * Description: char* addBasename(char* path) */
/*  * Synopsis   : add basename to the path */
/*  * Input      : char* path */
/*  * Output     : static char *: the new path */
/*  =======================================================================*\/ */
/* char* addBasename(BisonData* data, char* path) */
/* { */
/*   static char fullPath[256]; */
/*   int i = 0; */

/*   strncpy(fullPath, data->basename, 255); */
/*   i = strlen(data->basename); */
/*   fullPath[i++] = '/'; */
/*   strncpy(fullPath+i, path, 255- i - strlen(path)); */
/*   path[255] = 0; */

/*   return fullPath; */
/* } */

/*=======================================================================
 * Function   : yyerror
 * Description: Emit an error message. Called by the parser on error
 *              state.
 * Synopsis   : void seda_error(void* data, const char* message)
 * Input      : char* message = the error message.
 * Output     : N/A
 =======================================================================*/
void seda_error(void* data, const char* message)
{
  logMain(LOG_ERR, "Bison: %s",message);
  exit(1);
}

/*=======================================================================
 * Function   : createParser
 * Description: Create the push parser
 * Synopsis   : void* createParser (void) 
 * Input      : N/A
 * Output     : new push parser instance
 =======================================================================*/
void*
createParser (void) 
{
  return seda_pstate_new ();
}

/*=======================================================================
 * Function   : pushParser
 * Description: Push a token into the parser
 * Synopsis   : void pushParser (void* ps, int lexem, SEDA_STYPE* value,
 *                               BisonData* data)
 * Input      : void* ps: the parser instance
 *              int lexem: the token to push
 *              SEDA_STYPE* value: the value the token may have
 *              BisonData* data: the context use internaly by the parser
 * Output     : N/A
 * Note       : will exit on failure (as sax do)
 =======================================================================*/
void
pushParser (void* ps, int lexem, SEDA_STYPE* value, BisonData* data)
{
  seda_push_parse (ps, lexem, value, data);
}
 
/*=======================================================================
 * Function   : destroyParser
 * Description: Destroy the push parser
 * Synopsis   : void destroyParser (void* ps) 
 * Input      : the push parser instance
 * Output     : N/A
 =======================================================================*/
void
destroyParser (void* ps) 
{
  seda_pstate_delete ((yypstate *)ps);
}
 
/* Local Variables: */
/* mode: c *//* mode: font-lock */
/* mode: auto-fill */
/* End: */
