/*=======================================================================
 * Version: $Id: mediatex-config.h,v 1.5 2015/09/21 01:01:50 nroche Exp $
 * Project: MediaTex
 * Module : headers
 *
 * This file include the config.h file generated by ./configure.
 * It should only be included by the mediatex binaries, because library 
 * users should provide the same standard definitions by using  automake
 * too for instance.
 * 

 MediaTex is an Electronic Records Management System
 Copyright (C) 2014 2015 Nicolas Roche

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
=======================================================================*/

#ifndef MDTX_CONFIG_H
#define MDTX_CONFIG_H 1

#include "mediatex.h"   // general API
#include "misc/alloc.h" // mediatex use its own allocator
#include "config.h"     // generated by ./configure

// Below values ar defined by config.h.
// Installers are expected to override these default values when calling 
// make (make prefix=/usr install) or configure (configure --prefix=/usr).
// However, mediatex is using too theses values.
// So, DO NOT use make to overide theses values but USE ./configure.

// Default values are :
// CONF_PREFIX = ""
// CONF_EXEC_PREFIX = /usr
// CONF_SYSCONFDIR = CONF_PREFIX "/etc"
// CONF_LOCALSTATEDIR = CONF_PREFIX "/var"
// CONF_BINDIR = CONF_EXEC_PREFIX "/bin"
// CONF_DATAROOTDIR = CONF_EXEC_PREFIX "/share"
// CONF_MEDIATEXDIR "/mediatex"

// Debian package use the following values :
// cf /usr/share/perl5/Debian/Debhelper/Buildsystem/autoconf.pm
/* $ ./configure \
     --prefix=/usr \
     --includedir=/usr/include \
     --mandir=/usr/share/man \
     --infodir=/usr/share/info \
     --sysconfdir=/etc \
     --localstatedir=/var \
     --libexecdir=/usr/lib/mediatex
*/

// Scripts are finalised by putting the above definition into too.
// However, the folowing values are hard-coded into the scripts.
// If you change them here, you have to reproduces changes into the
// 2 scripts's headers utmediatex.src and include.src.

// absolute paths
#define CONF_ETCDIR   CONF_SYSCONFDIR CONF_MEDIATEXDIR
#define CONF_DATADIR  CONF_DATAROOTDIR CONF_MEDIATEXDIR
#define CONF_STATEDIR CONF_LOCALSTATEDIR "/lib" CONF_MEDIATEXDIR
#define CONF_CACHEDIR CONF_LOCALSTATEDIR "/cache" CONF_MEDIATEXDIR
#define CONF_PIDDIR   CONF_LOCALSTATEDIR "/run" CONF_MEDIATEXDIR
#define CONF_SCRIPTS  CONF_DATADIR  "/scripts"
#define CONF_MISC     CONF_DATADIR  "/misc"
#define CONF_HOSTSSH  CONF_SYSCONFDIR "/ssh"

// relative paths
#define CONF_MD5SUMS  "/md5sums"
#define CONF_CACHES   "/cache"
#define CONF_EXTRACT  "/tmp"
#define CONF_HOME     "/home"
#define CONF_CVSCLT   "/cvs"
#define CONF_SSHDIR   "/.ssh"
#define CONF_HTMLDIR  "/public_html"
#define CONF_CONFFILE ".conf"
#define CONF_PIDFILE  "d.pid"
#define CONF_SUPPD    ":supports/"
#define CONF_AUDIT    "audit_"

// basenames
#define CONF_SUPPFILE  "/supports.txt"
#define CONF_SERVFILE  "/servers"
#define CONF_CATHFILE  "/catalog"
#define CONF_EXTRFILE  "/extract"
#define CONF_RSAUSERKEY "/id_rsa.pub"
#define CONF_DSAUSERKEY "/id_dsa.pub"
#define CONF_RSAHOSTKEY "/ssh_host_rsa_key.pub"
#define CONF_DSAHOSTKEY "/ssh_host_dsa_key.pub"
#define CONF_SSHKNOWN  "/known_hosts"
#define CONF_SSHAUTH   "/authorized_keys"
#define CONF_SSHCONF   "/config"
#define CONF_COLLKEY   "/aesKey.txt"
#define TESTING_PORT  6560
#define CONF_PORT     6561 // (as default)
#define SSH_PORT      22
#define WWW_PORT      443

#endif /* MDTX_CONFIG_H */

/* Local Variables: */
/* mode: c */
/* mode: font-lock */
/* End: */
