#!/bin/bash
#=======================================================================
# * Version: $Id: include.src,v 1.5 2015/07/01 11:33:50 nroche Exp $
# * Project: MediaTex
# * Module : script libs
# *
# * load mediatex path and variables
#
# MediaTex is an Electronic Records Management System
# Copyright (C) 2014 2015 Nicolas Roche
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#=======================================================================
#set -x
set -e

# includes
MDTX_SH_INCLUDE=1
[ -z $srcdir ] && srcdir=.
[ -z $libdir ] && libdir=$srcdir/scripts/lib
[ ! -z $MDTX_SH_LOG ] || source $libdir/log.sh

# running variables from env (command.c)
UNIT_TEST_RUNNING=0
DRY_RUN=${MDTX_DRY_RUN-0}
MDTX=${MDTX_MDTXUSER-mdtx}

Debug "load $MDTX's paths"

# from automake (./configure)
MEDIATEX=/mediatex
BINDIR=/usr/local/bin
DATAROOTDIR=/usr/local/share
EXEC_PREFIX=/usr/local
LOCALSTATEDIR=/usr/local/var
PREFIX=/usr/local
SYSCONFDIR=/usr/local/etc

## copy/paste from mediatex.config
# note: values for unit tests are differents due to jails (utscripts.sh)

# path configuration variables for scripts
ETCDIR="${SYSCONFDIR}${MEDIATEX}"
DATADIR="${DATAROOTDIR}${MEDIATEX}"
STATEDIR="${LOCALSTATEDIR}/lib${MEDIATEX}"
CACHEDIR="${LOCALSTATEDIR}/cache${MEDIATEX}"
PIDDIR="${LOCALSTATEDIR}/run${MEDIATEX}"
SCRIPTS="${DATADIR}/scripts"
MISC="${DATADIR}/misc"
HOSTSSH="${SYSCONFDIR}/ssh"

# running variables from env (command.c)
DRY_RUN=${MDTX_DRY_RUN-0}
MDTX=${MDTX_MDTXUSER}

## NOT USED BY SHOULD BE

# relative paths
CONF_MD5SUMS="/md5sums"
CONF_CACHES="/cache"
CONF_EXTRACT="/tmp"
CONF_HOME="/home"
CONF_CVSCLT="/cvs"
CONF_SSHDIR="/.ssh"
CONF_HTMLDIR="/public_html"
CONF_CONFFILE=".conf"
CONF_PIDFILE="d.pid"

# basenames
CONF_SUPPFILE="/supports.txt"
CONF_SERVFILE="/servers"
CONF_CATHFILE="/catalog"
CONF_EXTRFILE="/extract"
CONF_RSAUSERKEY="/id_rsa.pub"
CONF_DSAUSERKEY="/id_dsa.pub"
CONF_RSAHOSTKEY="/ssh_host_rsa_key.pub"
CONF_DSAHOSTKEY="/ssh_host_dsa_key.pub"
CONF_SSHKNOWN="/known_hosts"
CONF_SSHAUTH="/authorized_keys"
CONF_SSHCONF="/config"
CONF_COLLKEY="/aesKey.txt"
TESTING_PORT=6560
CONF_PORT=6561
SSH_PORT=22

# recurent variables
CVSROOT="${STATEDIR}/$MDTX"
MDTXHOME="${CACHEDIR}/$MDTX"
MD5SUMS="${MDTXHOME}${CONF_MD5SUMS}"
CACHES="${MDTXHOME}${CONF_CACHES}"
EXTRACT="${MDTXHOME}${CONF_EXTRACT}"
CVSCLT="${MDTXHOME}${CONF_CVSCLT}"
HOMES="${MDTXHOME}${CONF_HOME}"
MDTXCVS="${CVSCLT}/$MDTX"
CONFFILE="${MDTXCVS}/$MDTX${CONF_CONFFILE}"
PIDFILE="${PIDDIR}/$MDTX${CONF_PIDFILE}"

FALSE=1
TRUE=0
