#!/bin/bash
#=======================================================================
# * Version: $Id: utmediatex.src,v 1.4 2015/08/30 17:07:55 nroche Exp $
# * Project: MediaTex
# * Module : C codes
# *
# * This script is include by all C unit tests
#
# MediaTex is an Electronic Records Management System
# Copyright (C) 2014 2015 Nicolas Roche
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#=======================================================================
#set -x
set -e

# from automake (./configure)
MEDIATEXDIR=/mediatex
BINDIR=/usr/local/bin
DATAROOTDIR=/usr/local/share
EXEC_PREFIX=/usr/local
LOCALSTATEDIR=/usr/local/var
PREFIX=/usr/local
SYSCONFDIR=/usr/local/etc

# add/remove prefix to match check/distcheck cases
INST=${PWD%"/_build/check"}
INST="${INST}/_inst"
TMP="${PWD}/tmp"
BINDIR=${TMP}${BINDIR#$INST}
DATAROOTDIR=${TMP}${DATAROOTDIR#$INST}
EXEC_PREFIX=${TMP}${EXEC_PREFIX#$INST}
LOCALSTATEDIR=${TMP}${LOCALSTATEDIR#$INST}
PREFIX=${TMP}${PREFIX#$INST}
SYSCONFDIR=${TMP}${SYSCONFDIR#$INST}

## copy/paste from mediatex.config
# $1 : MDTXUSER
function loadPaths()
{
    MDTXUSER="$1"

    # path configuration variables for unit tests: 
    ETCDIR="${SYSCONFDIR}${MEDIATEXDIR}"
    DATADIR="${DATAROOTDIR}${MEDIATEXDIR}"
    STATEDIR="${LOCALSTATEDIR}/lib${MEDIATEXDIR}"
    CACHEDIR="${LOCALSTATEDIR}/cache${MEDIATEXDIR}"
    PIDDIR="${LOCALSTATEDIR}/run${MEDIATEXDIR}"
    SCRIPTS="${DATADIR}/scripts"
    MISC="${DATADIR}/misc"
    HOSTSSH="${SYSCONFDIR}/ssh"

    # relative paths
    CONF_MD5SUMS="/md5sums"
    CONF_CACHES="/cache"
    CONF_EXTRACT="/tmp"
    CONF_HOME="/home"
    CONF_CVSCLT="/cvs"
    CONF_SSHDIR="/.ssh"
    CONF_HTMLDIR="/public_html"
    CONF_CONFFILE=".conf"
    CONF_PIDFILE="d.pid"

    # basenames
    CONF_SUPPFILE="/supports.txt"
    CONF_SERVFILE="/servers"
    CONF_CATHFILE="/catalog"
    CONF_EXTRFILE="/extract"
    CONF_RSAUSERKEY="/id_rsa.pub"
    CONF_DSAUSERKEY="/id_dsa.pub"
    CONF_RSAHOSTKEY="/ssh_host_rsa_key.pub"
    CONF_DSAHOSTKEY="/ssh_host_dsa_key.pub"
    CONF_SSHKNOWN="/known_hosts"
    CONF_SSHAUTH="/authorized_keys"
    CONF_SSHCONF="/config"
    CONF_COLLKEY="/aesKey.txt"
    TESTING_PORT=6560
    CONF_PORT=6561
    SSH_PORT=22

    # files with relatives path
    SUPPFILE="${CONF_SUPPFILE}"
    SERVFILE="${CONF_SERVFILE}.txt"
    CATHFILE="${CONF_CATHFILE}000.txt"
    EXTRFILE="${CONF_EXTRFILE}000.txt"

    # recurent variables
    CVSROOT="${STATEDIR}/${MDTXUSER}"
    MDTXHOME="${CACHEDIR}/${MDTXUSER}"
    MD5SUMS="${MDTXHOME}${CONF_MD5SUMS}"
    CACHES="${MDTXHOME}${CONF_CACHES}"
    EXTRACT="${MDTXHOME}${CONF_EXTRACT}"
    CVSCLT="${MDTXHOME}${CONF_CVSCLT}"
    HOME="${MDTXHOME}${CONF_HOME}"
    MDTXCVS="${CVSCLT}/${MDTXUSER}"
    CONFFILE="${MDTXCVS}/${MDTXUSER}${CONF_CONFFILE}"
    PIDFILE="${PIDDIR}/${MDTXUSER}${CONF_PIDFILE}"
}

# $1 : collection label : ${MDTXUSER}-test${COLL}"
function populateCollection()
{
    TARGET=$HOME/$1

    # simulate collection directory build during creation
    install -m 750 -d $TARGET
    install -m 770 -d $TARGET/cvs
    install -m 700 -d $TARGET/.ssh
    install -m 750 -d $TARGET/public_html
    install -m 750 -d $TARGET/public_html/index
    install -m 750 -d $TARGET/public_html/cache
    install -m 750 -d $TARGET/public_html/score
    install -m 750 -d $TARGET/public_html/cgi

    install -m 750 -d $CACHES/$1
    install -m 770 -d $EXTRACT/$1
    install -m 750 -d $CVSROOT/$1
    install -m 770 -d $CVSCLT/$1

    touch $CVSCLT/$1$CATHFILE
    touch $CVSCLT/$1$EXTRFILE
}

# so as to pass unit test easier
# $1: unit test's output file
function mrProperOutputs()
{
    # hide line numbers
    sed $1 -i -e "s,^\(\[.*\):.*\],\1],"

    # hide base directories path
    sed $1 -i \
	-e "s,$SYSCONFDIR,SYSCONFDIR,g" \
	-e "s,$LOCALSTATEDIR,LOCALSTATEDIR,g" \
	-e "s,$DATAROOTDIR,DATAROOTDIR,g" \
	-e "s,${PWD%check},/HERE/,g" \
	-e "s,${PWD%_build/check},/HERE/,g" \
	-e "s,mediatex-.\../_build/,,g" \
	-e "s,mediatex-.\../,,g"


    # hide uid
    sed $1 -i -e "s,\(logoutUser\).*,\1 XXX,"

    # hide cvs versionning id
    sed $1 -i -e "s,^\(# Version: \).*,\1 XXX,"

    # make distcheck on server
    sed $1 -i -e "s,../../check/,./,"
}

# set MDTXUSER values to "mdtx1"
loadPaths "mdtx1"

# do not do that when call by other unit-tests
if [ "$0" == "./utmediatex.sh" ]; then

    echo -e "\n* Autotools inputs:"
    echo "MEDIATEXDIR=$MEDIATEXDIR"
    echo "BINDIR=$BINDIR"
    echo "DATAROOTDIR=$DATAROOTDIR"
    echo "EXEC_PREFIX=$EXEC_PREFIX"
    echo "LOCALSTATEDIR=$LOCALSTATEDIR"
    echo "PREFIX=$PREFIX"
    echo "SYSCONFDIR=$SYSCONFDIR"
    
    echo -e "\n* path configuration variables for unit tests:"
    echo "ETCDIR=$ETCDIR"
    echo "DATADIR=$DATADIR"
    echo "STATEDIR=$STATEDIR"
    echo "CACHEDIR=$CACHEDIR"
    echo "PIDDIR=$PIDDIR"
    echo "SCRIPTS=$SCRIPTS"
    echo "MISC=$MISC"
    echo "HOSTSSH=$HOSTSSH"
    
    echo -e "\n-- mediatex server paths:"
    echo "HOSTSSH = $HOSTSSH"
    echo "PIDDIR = $PIDDIR"
    echo "CVSROOT = $CVSROOT"
    echo "MD5SUMS = $MD5SUMS"
    echo "CACHES = $CACHES"
    echo "EXTRACT = $EXTRACT"
    echo "CVSCLT = $CVSCLT"
    echo "HOME = $HOME"
    echo "MDTXCVS = $MDTXCVS"
    echo "CONFFILE = $CONFFILE"
    echo "PIDFILE = $PIDFILE"

    echo -e "\n-- mediatex collection basenames:"
    echo "SUPPFILE = $SUPPFILE"
    echo "SERVFILE = $SERVFILE"
    echo "CATHFILE = $CATHFILE"
    echo "EXTRFILE = $EXTRFILE"
fi
