/*
   The Born-Mayer interatomic potential implementation
   (header file).

   Copyright (C) 2004, 2005, 2009 Oleksandr Yermolenko
   <oleksandr.yermolenko@gmail.com>

   This file is part of MDTK, the Molecular Dynamics Toolkit.

   MDTK is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   MDTK is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with MDTK.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef mdtk_FBM_hpp
#define mdtk_FBM_hpp

#include "FPairwise.hpp"

namespace mdtk
{

class FBM : public FPairwise
{
private:
  Float A3[EL_ID_size][EL_ID_size];
  Float A4[EL_ID_size][EL_ID_size];
public:  
  Float F11(Atom& a1, Atom& a2);
  Vector3D dF11(Atom& a1, Atom& a2, Atom& da);
public:
  virtual Float operator()(AtomsContainer&);
  virtual Vector3D grad(Atom &,AtomsContainer&);
  FBM(Rcutoff = Rcutoff());

  void SaveToStream(std::ostream& os, YAATK_FSTREAM_MODE smode)
  {
    FPairwise::SaveToStream(os,smode);
  }  
  void LoadFromStream(std::istream& is, YAATK_FSTREAM_MODE smode)
  {
    FPairwise::LoadFromStream(is,smode);
  }  
};

} // namespace mdtk

#endif

