/*
   Some physical constants.

   Copyright (C) 2004, 2005, 2009 Oleksandr Yermolenko
   <oleksandr.yermolenko@gmail.com>

   This file is part of MDTK, the Molecular Dynamics Toolkit.

   MDTK is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   MDTK is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with MDTK.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <mdtk/consts.hpp>

namespace mdtk
{

const Float amu = 1.6605655e-24; // CGSE
const Float e   = 4.8e-10; // CGSE
const Float Ao  = 1e-8; // CGSE
const Float eV  = 1.6021E-012; // CGSE
const Float kb  = 8.617343E-5*eV;
const Float K  = 1.0;

const Float ps = 1e-12;
const Float fs = 1e-15;

const Float Deg  = M_PI/180.0; 

}

