// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef ONEDATA_H
#define ONEDATA_H

#include <wx/object.h>
#include <wx/bitmap.h>
#include <wx/wxexpr.h>
#include <wx/panel.h>

#include <vector>
using namespace std;

#include <config.h>
#include "../checksetup.h"

namespace One
{
 class OneData;
}

#include "../application.h"
#include "../introwc.h"
#include "../theme.h"
#include "one.h"
#include "onepanel.h"

namespace One
{
// The *OneData classes are for the *One classes what the RoomList is
// for the Application.

// The Screen struct is the struct used for communication with the
// OnePanel.

struct EXPORT Screen
{
  vector<wxBitmap*> images;

  typedef vector<wxBitmap*>::iterator image_iterator;

  virtual ~Screen()
  { for(image_iterator iter = images.begin(); iter != images.end(); ++iter)
  { delete *iter; *iter = NULL; } }
};

class EXPORT OneData
{
public:
  OneData(const wxString &filename, One *one) throw(Exception);

  Screen *cGetScreen() throw(Exception);
protected:
  virtual void AddAnswersToScreen(wxExpr *e_screen, Screen *screen) = 0;

  virtual Screen *cScreen() throw(Exception) = 0;

public:
  void SaveData(const wxString &title) const throw();

protected:
  wxExprDatabase *m_db;
  One *m_one;
  wxString m_current_screen;
};

}

#endif // ONEDATA_H

// 
// Local Variables:
// mode: c++
// End:
