// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/memory.h>
#include <new>

#include <config.h>
#include "../checksetup.h"

#include "../application.h"
#include "../htmlpanel.h"
#include "../introwc.h"
#include "one.h"
#include "onepanel.h"

namespace One
{

void One::Init(const wxExpr *ex,
	       wxPanel *panel) throw(Exception)
try
{
  wxLogTrace("entering", "One::Init()");

  try
  {
    GetApp()->GetCurrentWC()->Destroy();
  }
  catch(NullException &ex) {} 	// harmless, there is no current wc.

  try
  {
    IntroWC::Init(ex, panel);
  }
  catch(SilentException &ex)
  {
    GetTopWindow()->DoSoon(m_pc);
    // If the Intro part fails to load, we create the main panel soon
    // (m_pc is the PanelCreator from IntroWC)
  }

  try
  {
    GetLocalizedAttribute(expr, "control_file", m_filename); 
    m_filename = GetApp()->config->GetModuleDataFile(m_filename);
  }
  catch(Exception &ex)
  {
    throw NoisyException("Malformed item in room list: this "
			 "module requires the attribute "
			 "\"control_file\". This file should "
			 "be in the same directory as the module.");
  }


  wxString theme_name;
  expr->GetAttributeValue("theme", theme_name);
  if(theme_name != wxEmptyString)
    m_theme = new Theme(theme_name);
  else
    m_theme = NULL;
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

void One::ReloadPanel() throw()
try
{
  if(m_panel != NULL)
  {
    m_panel->Destroy();
    m_panel = NULL;
  }
  EnterRoom();
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

wxExpr* One::cHibernate() throw(Exception)
try
{
  wxASSERT(m_data != NULL);
  wxASSERT(expr != NULL);

  m_data->SaveData(expr->Functor() + "_data");
  return expr->Copy();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

void One::Destroy() throw()
{
  wxLogTrace("entering", "One::Destroy(): clearing window.");
  
  main_panel->DestroyChildren(); 

  if(m_theme != NULL)
  {
    delete m_theme;
    m_theme = NULL;
  }

  if(m_data != NULL)
  {
    delete m_data;
    m_data = NULL;
  }
}

  void Restarter::operator()() throw()
  {
    m_one->ReloadPanel();
  }
}
