// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <wx/frame.h>
#include <wx/panel.h>

#include <config.h>
#include "checksetup.h"

#include "command_processor.h"
#include "module.h"
#include "windowcontents.h"

class MainWindow: public wxFrame
{
public:
  MainWindow() throw(Exception);

  // File menu
  void OnExit(wxCommandEvent &event) throw();
  void OnOpen(wxCommandEvent &event) throw();
  void OnSave(wxCommandEvent &event) throw();

  // Debug menu
#ifdef __WXDEBUG__
  void OnMenuReplace(wxCommandEvent &event) throw();
#endif

  void OnReplace(wxCommandEvent &event) throw();
  void OnClose(wxCloseEvent &event) throw();
  
  void ReplaceSoon(const wxString &room) throw();

  // Some functions might need to be executed when there is no other
  // active code, e.g. if the function intends to delete the objects
  // that called it. To do that, simply register a CommandProcessor
  // with DoSoon(), and as soon as the currently pending events have
  // been handled, the CommandProcessor will be activated.
  void DoSoon(CommandProcessor &cp);
  void OnDo(wxCommandEvent &event) throw();

  friend class Application;

protected:
  DECLARE_EVENT_TABLE()

private:
  wxPanel *m_panel;
  CommandProcessor *m_cp;
};


// IDs of the different windows and actions. Since these will need to be
// unique most of the time, keeping the IDs of other classes here too
// ensures that there are no ID clashes.
enum {
//// IDs used by this class ////
  ID_REPLACE = wxID_HIGHEST + 1, // Replace requested by the program.
  MENU_REPLACE,                  // Replace requested by the user

  ID_DO,                         // Used by DoSoon() and OnDo()

//// IDs used by other classes (class name prepended) ////
  HTMLPANEL_BUTTON,		// The button of HtmlPanel is clicked
  ONEPANEL,
  ONEPANEL_ANSWERCTRL,

  ID_HIGHEST = wxID_HIGHEST + 1000 };
    

#endif // MAINWINDOW_H

// 
// Local Variables:
// mode: c++
// End:
