// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef TIMER_H
#define TIMER_H

#include <wx/timer.h>

#include <config.h>
#include "checksetup.h"

#include "exceptions.h"

// IMPORTANT: in all communication with  the timer the unit of time is
// a  millisecond. In  all cases,  the time  integer is  the remaining
// time. When the time_left reaches 0, the program is terminated (game
// over).

class Timer: public wxTimer
{
public:
  Timer(int time_left) throw();

  void Start() throw(Exception);
  virtual void Notify() throw();

  // void Stop() is inherited from wxTimer.

  // Use these to change the value of a timer. (Note that it would not
  // make sense to overload ++ or -- (why bother with adding/removing
  // single milliseconds?))
  Timer &operator=(const Timer &t);
  Timer &operator=(int n);
  Timer &operator+=(int n);
  Timer &operator-=(int n);
  Timer &operator*=(int n);
  Timer &operator/=(int n);

  operator int() { return m_time_left; }
private:
  int m_time_left;
};


#endif // TIMER_H

// 
// Local Variables:
// mode: c++
// End:
