// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef THEME_H
#define THEME_H

#include <wx/string.h>
#include <wx/wxexpr.h>
#include <wx/app.h>
#include <wx/panel.h>
#include <new>

#include <config.h>
#include "checksetup.h"

#include "exceptions.h"

class EXPORT Theme
{
public:
  Theme(const wxString& functor) throw(Exception);
  Theme(const wxExpr *expr) throw(Exception) { Init(expr); }
  ~Theme() throw();

  int GetTopBorder() const throw() { return m_tb_height; }
  int GetBottomBorder() const throw() { return m_bb_height; }
  int GetLeftBorder() const throw() { return m_lb_width; }
  int GetRightBorder() const throw() { return m_rb_width; }

  // Setting the text background or foreground will only have effect
  // if you use one of the following accessors. The Theme class makes
  // no use of them.
  wxColour GetBackground() const throw() { return m_background; }
  wxColour GetTextBackground() const throw() { return m_text_background; }
  wxColour GetTextForeground() const throw() { return m_text_foreground; }

private:
  void Init(const wxExpr *expr) throw(Exception);
  void InitNumbers(const wxExpr *expr) throw();
  void InitBorders(const wxExpr *expr) throw();
  void InitColour(const wxExpr *expr) throw();

public:
  void Draw(wxDC &dc, int width, int height) const throw();
private:
  void DrawMainBitmap(wxBitmap *bitmap, wxDC &dc,
		      int width, int height) const throw();
  void DrawBorderImages(wxDC &dc, int width, int height) const throw();

private:
  // Prefixes:
  //   t = top
  //   l = left
  //   r = right
  //   b = bottom
  // Suffixes:
  //   b = border
  //   c = corner

  int m_tb_height;
  int m_bb_height;
  int m_lb_width;
  int m_rb_width;

  wxBitmap *m_tlc_image;
  wxBitmap *m_trc_image;
  wxBitmap *m_blc_image;
  wxBitmap *m_brc_image;

  wxBitmap *m_lb_image;
  wxBitmap *m_tb_image;
  wxBitmap *m_rb_image;
  wxBitmap *m_bb_image;

  wxColour m_background;
  wxColour m_text_background;
  wxColour m_text_foreground;
  wxBitmap *m_big_image;
  wxBitmap *m_image;
  enum placement_t { tiled, centered } m_placement;
};

#endif // THEME_H

// 
// Local Variables:
// mode: c++
// End:
