// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/layout.h>
#include <wx/event.h>
#include <wx/intl.h>
#include <wx/dcclient.h>
#include <wx/image.h>

#include <iostream>

#include <config.h>
#include "../checksetup.h"

#include "../application.h"
#include "../button.h"
#include "../windowcontents.h"
#include "initialscreen.h"
#include "initialpanel.h"

InitialPanel::InitialPanel(InitialScreen *is) throw(Exception) try:
  m_is(is),
  wxPanel(is->main_panel, -1,
	  wxDefaultPosition, is->main_panel->GetClientSize(),
	  wxTAB_TRAVERSAL)
{
  wxLogDebug("Constructing InitialPanel...");

  // wxWS_EX_TRANSIENT: This can be used to prevent a window from
  // being used as an implicit parent for the dialogs which were
  // created without a parent. It is useful for the windows which can
  // disappear at any moment as creating children of such windows
  // results in fatal problems.
  SetExtraStyle(wxWS_EX_TRANSIENT);

  wxBoxSizer *hsizer = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer *vsizer = new wxBoxSizer(wxVERTICAL);

  Button *intro_button = new Button(this, BUTTON_INTRO, _("Intro"));
  vsizer->Add(intro_button, 0, wxCENTER | wxALL, 10);

  Button *skip_button = new Button(this, BUTTON_SKIP, _("Skip intro"));
  vsizer->Add(skip_button, 0, wxCENTER | wxALL, 10);

  hsizer->Add(vsizer, 1, wxALIGN_CENTER);

  intro_button->SetFocus();
  intro_button->SetToolTip(_("Display an introduction to the program."));
  intro_button->SetHelpText(_("Display an introduction to the program."));
  SetDefaultItem(intro_button);

  skip_button->SetToolTip(_("Start immediately, without any introduction."));
  skip_button->SetHelpText(_("Start immediately, without any introduction."));

  this->SetSizerAndFit(hsizer);

  wxBoxSizer *main_sizer = new wxBoxSizer(wxHORIZONTAL);
  main_sizer->Add(this, 1, wxEXPAND, 0);
  is->main_panel->SetSizer(main_sizer);

  is->main_panel->Layout();

  wxLogTrace("DC", "Creating a wxClientDC to do some drawing");
  wxClientDC dc(this);
  Draw(dc);
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

InitialPanel::~InitialPanel() throw()
{
  wxLogDebug("Destructing InitialPanel.");
}

void InitialPanel::OnButtonIntro(wxCommandEvent &event) throw()
try
{
  wxLogDebug("Intro button chosen");
  m_is->GoThroughDoor("intro");
}
catch(Exception &ex)
{
  if(!ex.Close())
    abort();
}

void InitialPanel::OnPaint(wxPaintEvent &event) throw()
try
{
  wxLogTrace("DC", "Creating a new wxPaintDC: Repainting...");
  wxPaintDC dc(this);
  Draw(dc);
}
catch(Exception &ex)
{
  if(!ex.Close())
    abort();
}

void InitialPanel::Draw(wxDC &dc) throw()
{
  int width = 0, height = 0;
  GetSize(&width, &height);

  if(m_is->m_theme != NULL)
    m_is->m_theme->Draw(dc, width, height);
}

void InitialPanel::OnButtonSkip(wxCommandEvent &event) throw()
try
{
  wxLogDebug("Skip button chosen");
  m_is->GoThroughDoor("first_room");
}
catch(Exception &ex)
{
  if(!ex.Close())
    abort();
}


BEGIN_EVENT_TABLE(InitialPanel, wxPanel)
  EVT_BUTTON  (BUTTON_INTRO,   InitialPanel::OnButtonIntro)
  EVT_BUTTON  (BUTTON_SKIP,    InitialPanel::OnButtonSkip)
  EVT_PAINT   (                InitialPanel::OnPaint)
END_EVENT_TABLE()
