// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef HTMLPANEL_H
#define HTMLPANEL_H

#include <wx/button.h>

#include <config.h>
#include "checksetup.h"

#include "command_processor.h"
#include "mainwindow.h"

// This class provides a panel with an HTML window and a button, useful
// for showing short intro messages before entering a room.

class EXPORT HtmlPanel: public wxPanel
{
public:
  HtmlPanel(WindowContents *wc,          // The WindowContents object
	    const wxString &html_file,   // The HTML file to display
	    const wxString &button_text, // The text on the button
	    const wxString &button_help, // Help text for the button
	    CommandProcessor &cp         // A function-like object or a callback function
	    ) throw(Exception);

  virtual ~HtmlPanel() throw();


protected:
  DECLARE_EVENT_TABLE();

  void OnButton(wxCommandEvent &event) throw();

protected:
  WindowContents *m_wc;

private:
  CommandProcessor &m_cp;
};

#endif // HTMLPANEL_H

// 
// Local Variables:
// mode: c++
// End:
