// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "button.h"

#include <wx/log.h>
#include <wx/cshelp.h>

#include <config.h>
#include "checksetup.h"

#include "application.h"

Button::~Button() throw()
try
{
  if(wxHelpProvider::Get() != NULL && GetTopWindow()->GetStatusBar() != NULL)
  {
    if(GetTopWindow()->GetStatusBar()->GetStatusText() == GetHelpText())
      GetTopWindow()->SetStatusText(wxEmptyString);
  }
}
catch(NullException &ex)
{
  wxLogDebug("*** WARNING *** Button destructor received NULL exception");
}

void Button::OnMouseEnter(wxMouseEvent &event) throw()
try
{
  if(wxHelpProvider::Get() == NULL)
  {
    wxLogDebug("There is no help provider, not showing help text.");
  }
  else
  {
    GetTopWindow()->SetStatusText(GetHelpText());
  }
  event.Skip();
}
catch(...)
{
  wxLogWarning(_("Button::OnMouseEnter caught an exception. This should not "
		 "happen."));
}

void Button::OnMouseLeave(wxMouseEvent &event) throw()
try
{
  GetTopWindow()->SetStatusText(wxEmptyString);
  event.Skip();
}
catch(...)
{
  wxLogWarning(_("Button::OnMouseLeave caught an exception. This should not "
		 "happen."));
}

BEGIN_EVENT_TABLE(Button, wxButton)
  EVT_ENTER_WINDOW(Button::OnMouseEnter)
  EVT_LEAVE_WINDOW(Button::OnMouseLeave)
END_EVENT_TABLE();
