// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <wx/string.h>
#include <wx/log.h>

#include "wordwrap.h"

#ifndef __WIN32__
wxString& WordWrap(wxString s) throw()
{
  int n = 0;
  int i = s.find(' ', 0);
  int iold = 0;
  int j = 0;
  while(i != wxString::npos && i <= s.length())
  {
    n += i - iold;
    if((j = s.find('\n', iold+1)) < i && j != wxString::npos)
    {
      i = j;
      n = 0;
    }
    if(n > 60)
    {
      s.GetWritableChar(i) = '\n';
      n %= 60;
    }
    iold = i;
    if(iold + 1 <= s.length())
      i = s.find(' ', iold+1);
  }
  return s;
}

#endif
