// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <wx/timer.h>
#include <wx/log.h>

#include "checksetup.h"

#include "mainwindow.h"
#include "application.h"
#include "timer.h"
#include "timeguard.h"

Timer::Timer(int time_left) throw():
  m_time_left(time_left)
{
  try
  {
    GetTopWindow()->SetStatusText(wxString::Format(_("Time left: %d:%.2d:%.2d"),
						   m_time_left/3600000,
						   (m_time_left%3600000)/60000,
						   ((m_time_left%3600000)%60000)/1000),
				  1); // 1 => the second pane.
  }
  catch(Exception &ex)
  {
    wxLogDebug("Timer caught exception: %s", ex.what());
  }
  catch(...)
  {
    wxLogDebug("Timer caught unknown exception.");
  }
}


void Timer::Start() throw(Exception)
{
  if(!wxTimer::Start(1000, wxTIMER_CONTINUOUS))
    throw NoisyException(_("Could not start timer. In some systems timers "
			   "are a limited resource. You might want to try "
			   "and close some other applications that might "
			   "be running."));
}

void Timer::Notify() throw()
try
{
  m_time_left -= GetInterval();
  GetTopWindow()->SetStatusText(wxString::Format(_("Time left: %d:%.2d:%.2d"),
						 m_time_left/3600000,
						 (m_time_left%3600000)/60000,
						 ((m_time_left%3600000)%60000)/1000),
				1); // 1 => the second pane.
  if((m_time_left/1000) % 60 == 0)
  {
    for(Application::TimeGuardIterator iter = GetApp()->TimeGuardBegin();
	iter != GetApp()->TimeGuardEnd();
	++iter)
    {
      (*iter)->TimeLeft(m_time_left/60000);
    }
  }
}
catch(Exception &ex)
{
  wxLogDebug("Timer caught exception: %s", ex.what());
}
catch(...)
{
  wxLogDebug("Timer caught unknown exception.");
}

Timer &Timer::operator=(const Timer &t)
{
  m_time_left = t.m_time_left;
  return *this;
}

Timer &Timer::operator=(int n)
{
  m_time_left = n;
  return *this;
}

Timer &Timer::operator+=(int n)
{
  m_time_left += n;
  return *this;
}

Timer &Timer::operator-=(int n)
{
  m_time_left -= n;
  return *this;
}

Timer &Timer::operator*=(int n)
{
  m_time_left *= n;
  return *this;
}

Timer &Timer::operator/=(int n)
{
  m_time_left /= n;
  return *this;
}

