// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef RGCHANGE_H
#define RGCHANGE_H

#include <wx/hashmap.h>
#include <wx/wxexpr.h>

#include <config.h>
#include "../checksetup.h"

#include "../exceptions.h"
#include "../roomguard.h"

class RGChange: public RoomGuard
{
public:
  virtual ~RGChange();

  virtual void Init(const wxExpr *expr) throw(Exception);

  virtual void Replace(wxExpr *new_room) throw(Exception);

private:
  wxString m_change;

  WX_DECLARE_STRING_HASH_MAP(wxExpr*, MyHash);
  MyHash m_hash;
};

#endif // RGCHANGE_H

// 
// Local Variables:
// mode: c++
// End:
