// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef PTR_H
#define PTR_H

#include <wx/object.h>

#include <config.h>
#include "checksetup.h"

#include "exceptions.h"

template <class T> class PtrData: public wxObjectRefData
{
public:
  PtrData(T *ptr) throw(): m_ptr(ptr) {}
  ~PtrData() throw() { delete m_ptr; }
  T *m_ptr;
};


template <class T> class Ptr: public wxObject
{
public:
  Ptr(T *ptr) { SetRefData(new PtrData<T>(ptr)); }
  Ptr(const Ptr<T> &ptr) { Ref(ptr); }
  ~Ptr() { UnRef(); }

  T* operator ->() { return dynamic_cast<PtrData<T> >(GetRefData())->m_ptr; }
  T& operator *() { return *(dynamic_cast<PtrData<T> >(GetRefData())->m_ptr); }

  Ptr<T>& operator=(const Ptr<T> &ptr)
  {
    if(&ptr == this)
      return *this;
    Ref(ptr);
    return *this;
  }
};

#endif // PTR_H

// 
// Local Variables:
// mode: c++
// End:
