// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <new>

#include <config.h>
#include "../checksetup.h"

#include "../windowcontents.h"
#include "multsim.h"
#include "multsimpanel.h"
#include "multsimdata.h"
#include "../application.h"

extern "C" char *version(void)
{
  return PACKAGE_STRING;
}

extern "C" char *type(void)
{
  return "WindowContents";	// This is a WindowContents object
}

void MultSim::Init(const wxExpr *ex,
		   wxPanel *panel) throw(Exception)
try
{
  wxLogDebug("Entering MultSim::Init()");
  WindowContents::Init(ex, panel);

  m_correct = 0;

  m_data = new MultSimData(this, expr);

  try
  {
    GetApp()->GetCurrentWC()->Destroy();
  }
  catch(NullException &ex) {} 	// harmless, there is no current wc.

  wxLogDebug("  Now constructing MultSimPanel");
  m_panel = new MultSimPanel(this, expr);
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

wxExpr* MultSim::cHibernate() throw(Exception)
try
{
  m_panel->SaveData(expr->Functor() + "_data");
  return expr->Copy();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

void MultSim::OneMoreCorrect() throw()
try
{
  m_correct++;
  if(m_correct >= m_data->GetColumns() * m_data->GetRows())
    GoThroughDoor("success");
  else 
    m_panel->GiveOneFocus();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}
catch(Exception &ex)
{
  if(!ex.Close())
    abort();
}

void MultSim::Destroy() throw()
{
  wxLogDebug("MultSim::Destroy(): clearing window.");
  main_panel->DestroyChildren();
  if(m_data)
  {
    delete m_data;
  }
}

// The class factories

extern "C" WindowContents* create(void)
{
  wxLogDebug("Creating an MultSim object.");
  return new(std::nothrow) MultSim();
}

extern "C" void destroy(WindowContents *w)
{
  wxLogDebug("Deleting a WindowContents object (i.e. an MultSim object)");
  delete w;
}
