// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef MODULE_H
#define MODULE_H

#include <wx/object.h>
#include <wx/config.h>
#include <wx/hashmap.h>
#include <wx/dynlib.h>

#include <config.h>
#include "checksetup.h"

#include "exceptions.h"

template <class T> class Module: private wxObject
{
public:
  // Loads the module and checks its version number.
  Module(const wxString &lib) throw(Exception);
  Module(const Module &mod) throw(NoisyBadAlloc); // Does NOT copy the object
  ~Module() throw();

  void CreateObject() throw(Exception);  
  bool IsLoaded() throw() { return is_loaded; }
  bool IsOk() throw() { return is_loaded && (object != NULL); }

  wxString GetLibraryName() const throw() { return m_lib; }

  T *object;

private:
  void LoadDynamicLibrary(const wxString &lib) throw(Exception);
  void CheckVersion() throw(Exception);  // Must LoadDynamicLibrary() first
  void LoadFactories() throw(Exception); // Must LoadDynamicLibrary() first

  class DynLibRefData: public wxObjectRefData
  {
  public:
    DynLibRefData(const wxString &libfile) throw(NoisyBadAlloc);
    ~DynLibRefData() throw();
    wxDynamicLibrary *m_dynamic_library;
  };

  wxDynamicLibrary *GetDynLib() throw ()
  { return dynamic_cast<DynLibRefData*>(GetRefData())->m_dynamic_library; }

  // The types of the class factories:
  typedef T* create_t();
  typedef void destroy_t(T*);

  static wxString object_type;

  create_t **m_create;
  destroy_t **m_destroy;
  bool is_loaded;
  wxString m_lib;
  wxString m_libfile;
};

#endif // MODULE_H

// 
// Local Variables:
// mode: c++
// End:
