// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/layout.h>
#include <wx/textctrl.h>
#include <wx/intl.h>
#include <wx/html/htmlwin.h>

#include <config.h>
#include "../checksetup.h"

#include "../windowcontents.h"
#include "../button.h"
#include "intro.h"
#include "intropanel.h"

IntroPanel::IntroPanel(Intro *is) throw(Exception) try:
  m_is(is),
  wxPanel(is->main_panel, -1,
	  wxDefaultPosition, is->main_panel->GetClientSize(),
	  wxTAB_TRAVERSAL)
{
  wxLogDebug("Constructing IntroPanel...");

  // wxWS_EX_TRANSIENT: This can be used to prevent a window from
  // being used as an implicit parent for the dialogs which were
  // created without a parent. It is useful for the windows which can
  // disappear at any moment as creating children of such windows
  // results in fatal problems.
  SetExtraStyle(wxWS_EX_TRANSIENT);

  wxBoxSizer *hsizer = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer *vsizer = new wxBoxSizer(wxVERTICAL);

  wxHtmlWindow *htmlwin = new wxHtmlWindow(this);
  vsizer->Add(htmlwin, 1, wxEXPAND | wxALL, 10);

  wxButton *button = new Button(this, BUTTON_FIRST_ROOM,_("First room in the maze"));
  button->SetToolTip(_("Start playing the game"));
  button->SetHelpText(_("Start playing the game"));
  vsizer->Add(button, 0, wxCENTER | wxALL, 10);

  htmlwin->SetPage(wxString::Format("<html><body><center>%s</center>"
				    "<p>%s</p><p>%s</p><p>%s</p><p>%s</p>"
				    "</body></html>",
		   _("<h1>Welcome to the Moon Base of UNSAFE</h1>"),
		   _("During the latter part of the 21st century, "
		     "scientists from all over the world joined in on "
		     "the United Nations Space And Flying Effort (UNSAFE). "
		     "The main goal of UNSAFE was to prepare colonisation "
		     "of other planets, and the first step was to establish "
		     "a settlement on the moon. Now, some 50 years later, "
		     "UNSAFE has anounced that their moon base is ready for "
		     "tourists, and you, naturally, stood on their "
		     "doorstep within seconds."),
		   _("You, the first tourist on the moon ever, have been "
		     "spending the past week-end on the moon, and have "
		     "thouroughly enjoyed yourself. This morning however, "
		     "you wake up to find the building unusually quiet and "
		     "empty. And there's a strange red light flashing on "
		     "the wall..."),
		   _("Why, it's a warning message! And it says that "
		     "everybody must leave the settlement as soon as "
		     "possible. A meteor is on its way, and will arrive "
		     "within an hour. The moon has no atmosphere to protect "
		     "its surface from meteors, so the consequences could "
		     "be disastrous if it hits the building."),
		   _("The astronouts have apparently already left. Most "
		     "of the emergency rockets are gone. There is in fact "
		     "only one left, and it's located on the other side of "
		     "the Math Maze, a place where astronouts test their "
		     "mathematical abilities. Well, what are you waiting "
		     "for? The meteor is comming. One hour...")));

  hsizer->Add(vsizer, 1, wxEXPAND);

  button->SetFocus();
  SetDefaultItem(button);
  this->SetSizerAndFit(hsizer);

  wxBoxSizer *main_sizer = new wxBoxSizer(wxHORIZONTAL);
  main_sizer->Add(this, 1, wxEXPAND, 0);
  is->main_panel->SetSizer(main_sizer);

  is->main_panel->Layout();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

IntroPanel::~IntroPanel()
{
  wxLogDebug("Destructing IntroPanel.");
}

void IntroPanel::OnButtonFirstRoom(wxCommandEvent &event) throw()
try
{
  wxLogDebug("\"First room\" button chosen");
  m_is->GoThroughDoor("first_room");
}
catch(Exception &ex)
{
  if(!ex.Close())
    abort();
}



BEGIN_EVENT_TABLE(IntroPanel, wxPanel)
  EVT_BUTTON  (BUTTON_FIRST_ROOM,    IntroPanel::OnButtonFirstRoom)
END_EVENT_TABLE()
