// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/layout.h>
#include <wx/textctrl.h>
#include <wx/intl.h>
#include <wx/html/htmlwin.h>

#include <config.h>
#include "../checksetup.h"

#include "../button.h"
#include "../windowcontents.h"
#include "../application.h"
#include "../exceptions.h"
#include "final.h"
#include "finalpanel.h"

FinalPanel::FinalPanel(Final *is, const wxExpr *expr) throw(Exception) try:
  m_is(is),
  wxPanel(is->main_panel, -1,
	  wxDefaultPosition, is->main_panel->GetClientSize(),
	  wxTAB_TRAVERSAL)
{
  wxLogDebug("Constructing FinalPanel...");

  // wxWS_EX_TRANSIENT: This can be used to prevent a window from
  // being used as an implicit parent for the dialogs which were
  // created without a parent. It is useful for the windows which can
  // disappear at any moment as creating children of such windows
  // results in fatal problems.
  SetExtraStyle(wxWS_EX_TRANSIENT);

  wxString message;
  if(! expr->GetAttributeValue("message", message))
  {
    throw NoisyException(_("Malformed item in room list: the final module "
			   "requires an attribute named \"message\"."));
  }

  if(message != "success" && message != "timeout")
  {
    throw NoisyException(_("Malformed item in room list: the final module "
			   "requires \"message\" to be either \"success\" "
			   "or \"timeout\"."));
  }

  wxBoxSizer *hsizer = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer *vsizer = new wxBoxSizer(wxVERTICAL);

  wxHtmlWindow *htmlwin = new wxHtmlWindow(this);
  vsizer->Add(htmlwin, 1, wxEXPAND | wxALL, 10);

  Button *button = new Button(this, wxID_EXIT, _("Exit the game"));
  button->SetToolTip(_("Quit this application"));
  button->SetHelpText(_("Quit this application"));

  vsizer->Add(button, 0, wxCENTER | wxALL, 10);

  if(message == "success")
  {
    htmlwin->SetPage(wxString::Format("<html><body><center>%s</center>"
				      "<p>%s</p>"
				      "</body></html>",
		   _("<h1>Congratulations</h1>"),
		   _("You succeeded in getting to the emergency rocket, "
		     "and are now swiftly disappearing from the surface "
		     "of the moon. After this you should certainly "
		     "qualify as an astronout for the next Moon Base "
		     "of UNSAFE.")));
  }
  else // message == "timeout"
  {
    htmlwin->SetPage(wxString::Format("<html><body><center>%s</center>"
				      "<p>%s</p>"
				      "</body></html>",
		   _("<h1>Sorry, but...</h1>"),
		   _("A big, grubby meteor is knocking on the door. You "
		     "didn't quite make it. Your death sends shock waves "
		     "through UNSAFE and in fact, the whole world. Space "
		     "travelling is <b>way</b> too dangerous, and plans on "
		     "colonizing other planets are quickly forgotten.")));
  }

  hsizer->Add(vsizer, 1, wxEXPAND);

  button->SetFocus();
  SetDefaultItem(button);
  this->SetSizerAndFit(hsizer);

  wxBoxSizer *main_sizer = new wxBoxSizer(wxHORIZONTAL);
  main_sizer->Add(this, 1, wxEXPAND, 0);
  is->main_panel->SetSizer(main_sizer);

  is->main_panel->Layout();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

FinalPanel::~FinalPanel() throw()
{
  wxLogDebug("Destructing FinalPanel.");
}

void FinalPanel::OnExit(wxCommandEvent &event) throw()
try
{
  wxLogDebug("\"Exit\" button chosen");
  GetTopWindow()->Close();
}
catch(NullException &ex)
{
  abort();			// If we can't close, we're in serious trouble
}


BEGIN_EVENT_TABLE(FinalPanel, wxPanel)
  EVT_BUTTON  (wxID_EXIT,    FinalPanel::OnExit)
END_EVENT_TABLE()
