// A mathematical game
// Copyright (C) 2004 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include <wx/filename.h>
#include <wx/intl.h>

#include "checksetup.h"

class Config;

#include "exceptions.h"

class Config
{
public:
  Config() throw(NoisyBadAlloc);
  ~Config() throw();

  wxString GetRoomListFile() throw(Exception); // may change RoomList file
  wxString GetModuleFile(const wxString &module_name) throw(Exception);
  wxString GetModuleDataFile(const wxString &filename) throw(Exception);

  // Use Set* from Command Line Parser only!
  void SetRoomListFile(const wxString &filename) throw(Exception)
		   {  return SetRoomListFile(wxFileName(filename));  }
  void SetRoomListFile(wxFileName filename) throw(Exception);

  void SetLocaleDir(wxString directory, wxLocale **locale) throw(Exception);
  void FindLocaleDir(wxLocale *locale) throw(NullException);

  void SetGenerateConfig(bool gc) throw();


  void GenerateConfig() throw();// Call when the config should be updated, will
  				// update if you have SetGenerateConfig(true);

  static const wxString module_path_env;
private:
  void LookForValidRoomListFile() throw(Exception);

  wxFileName m_roomlist_file;
  wxPathList m_module_path;
  wxString m_env;
  wxFileName m_localedir;
  bool m_generate_config;
};

#endif // CONFIGURATION_H

// 
// Local Variables:
// mode: c++
// End:
