/*- <matfquad/net/socket/Type.hpp> -*- C++ -*-
 *
 *
 *  matfquad
 *  Copyright (C) 2012  Márcio Adriano Tavares Fernandes
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
#ifndef __MATFQUAD_NET_SOCKET_TYPE_HPP__
#define __MATFQUAD_NET_SOCKET_TYPE_HPP__
#include "Parameter.hpp"

namespace matfquad
{
namespace net
{
namespace socket
{
class Type: public Parameter
{
 protected:
  static std::vector <Type *> list;
 public:
  Type();
  Type(int number);
  Type(int number, std::string name);
  Type(int number, std::string name, std::vector <std::string> nickname);
  ~Type();
};

class Type_DGRAM: public Type
{
 private:
  static Type_DGRAM instance;
  Type_DGRAM();
 public:
  static Type *getInstance();
};

class Type_STREAM: public Type
{
 private:
  static Type_STREAM instance;
  Type_STREAM();
 public:
  static Type *getInstance();
};
}
}
}

#endif
