#include <iostream>
#include <matfquad/net/socket/Socket.hpp>
using namespace matfquad::net::socket;

int main(int argc, char *argv[])
{
  if ( argc < 2 )
  {
    std::cerr << "Use: " << argv[0] << " server [service/port] " << std::endl;
    return EXIT_FAILURE;
  }
  std::string server(argv[1]);
  std::string service((( argc >= 3 ) ? argv[2]: "80"));
  Socket *s = new Socket(Socket::FAMILY_INET, Socket::TYPE_STREAM, Socket::PROTOCOL_TCP);
  std::cout << std::endl << "Connecting..." << std::endl;
  s->connect(server, service);
  std::cout << std::endl << "Connected!" << std::endl << std::endl;
  std::cout << ".Local host ────────: " << s->getAddress().getHostname() << std::endl;
  std::cout << "├─── Sock Family ───: " << s->getAddress().getFamily().getName() << std::endl;
  std::cout << "├─── Sock Type ─────: " << s->getAddress().getType().getName() << std::endl;
  std::cout << "└─── Sock Protocol ─: " << s->getAddress().getProtocol().getNicknames().at(0) << std::endl << std::endl;
  std::cout << ".Remote host ───────: " << s->getPeerAddress().getHostname() << std::endl;
  std::cout << "├─── Sock Family ───: " << s->getPeerAddress().getFamily().getName() << std::endl;
  std::cout << "├─── Sock Type ─────: " << s->getPeerAddress().getType().getName() << std::endl;
  std::cout << "└─── Sock Protocol ─: " << s->getPeerAddress().getProtocol().getNicknames().at(0) << std::endl << std::endl;
  std::string buffer("GET\n");
  s->send((void *)buffer.c_str(), buffer.size());
  buffer.clear();
  buffer.resize(4096, '\0');
  s->receive((void *)buffer.c_str(), buffer.size());
  std::cout << std::endl << buffer << std::endl;
  delete s;
  return EXIT_SUCCESS;
}

