/*- <matfquad/net/socket/Family.hpp> -*- C++ -*-
 *
 *
 *  matfquad
 *  Copyright (C) 2012  Márcio Adriano Tavares Fernandes
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
#ifndef __MATFQUAD_NET_SOCKET_FAMILY_HPP__
#define __MATFQUAD_NET_SOCKET_FAMILY_HPP__
#include "Parameter.hpp"

namespace matfquad
{
namespace net
{
namespace socket
{
class Family: public Parameter
{
 protected:
  static std::vector <Family *> list;
 public:
  Family();
  Family(int number);
  Family(int number, std::string name);
  Family(int number, std::string name, std::vector <std::string> nickname);
  ~Family();
};

class Family_INET: public Family
{
 private:
  static Family_INET instance;
  Family_INET();
 public:
  static Family *getInstance();
};

class Family_INET6: public Family
{
 private:
  static Family_INET6 instance;
  Family_INET6();
 public:
  static Family *getInstance();
};
}
}
}

#endif
