/*- <matfquad/net/socket/Address.hpp> -*- C++ -*-
 *
 *
 *  matfquad
 *  Copyright (C) 2012  Márcio Adriano Tavares Fernandes
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
#ifndef __MATFQUAD_NET_SOCKET_ADDRESS_HPP__
#define __MATFQUAD_NET_SOCKET_ADDRESS_HPP__
#include <string>
#include <vector>
#include <stdexcept>
#include "Family.hpp"
#include "Type.hpp"
#include "Protocol.hpp"

namespace matfquad
{
namespace net
{
namespace socket
{
class address_error: public std::runtime_error
{
 public:
  explicit address_error(): address_error("Address error")
  {
  }
  explicit address_error(const std::string &msg): std::runtime_error(msg)
  {
  }
};

class Address
{
 public:
  static const int NAMETOADDRESS_CANONNAME;
  static const int NAMETOADDRESS_NUMERICHOST;
  static const int NAMETOADDRESS_PASSIVE;
  static const int NAMETOADDRESS_DEFAULT;
  static const int ADDRESSTONAME_NAMEREQUIRED;
  static const int ADDRESSTONAME_NONFULLYQUALIFIEDDOMAINNAME;
  static const int ADDRESSTONAME_NUMERICHOST;
  static const int ADDRESSTONAME_NUMERICSERVICE;
  static const int ADDRESSTONAME_DEFAULT;
 private:
  int name_to_address_flags;
  int address_to_name_flags;
  Family family;
  Type type;
  Protocol protocol;
  size_t address_length;
  void *address;
  std::string hostname;
  Address *next;
 public:
  Address();
  Address(std::string hostname, std::string service, int family, int type, int protocol) throw (address_error);
  Address(std::string hostname, std::string service, int family, int type, int protocol, int name_to_address_flags) throw (address_error);
  Address(std::string hostname, std::string service, Family *family, Type *type, Protocol *protocol) throw (address_error);
  Address(std::string hostname, std::string service, Family *family, Type *type, Protocol *protocol, int name_to_address_flags) throw (address_error);
  Address(void *address, size_t address_length, int family, int type, int protocol) throw (address_error);
  Address(void *address, size_t address_length, int family, int type, int protocol, int name_to_address_flags, int address_to_name_flags) throw (address_error);
  Address(void *address, size_t address_length, Family *family, Type *type, Protocol *protocol) throw (address_error);
  Address(void *address, size_t address_length, Family *family, Type *type, Protocol *protocol, int name_to_address_flags, int address_to_name_flags) throw (address_error);
  Address(void *hints);
  Address(Address *address);
  ~Address();
  void assign(Address *address);
  void assign(void *hints);
  void clear();
  void *getAddress();
  size_t getAddressLength();
  int getAddressToNameFlags();
  Family getFamily();
  int getFamilyNumber();
  std::string getHostname();
  int getNameToAddressFlags();
  Address *getNext();
  Protocol getProtocol();
  int getProtocolNumber();
  Type getType();
  int getTypeNumber();
};
}
}
}

#endif
