/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2009,2012 COLLARD Christophe
 * copyright © 2009 BERBENNI Stephane
 * copyright © 2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2009 Arts et Métiers ParisTech
 * copyright © 2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    walpole-tests belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type walpole test
#endif

#ifndef __walpole_test_hpp
#define __walpole_test_hpp

#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __parameters_h
#include "parameters.h"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __walpole_hpp
#include "MateriOL++/walpole.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace materiol;


//===========================
int test_walpole (int detail)
//===========================
{
  bool result = true;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                     walpole test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  tensor2<long double> t2sr(3);
  for (int i=1; i<=3; i++)
    for (int j=i; j<=3; j++)
      t2sr (i,j) = t2sr(j,i) = i*pi()+2*j;
  vector<long double>  v2sr = walpole::symtensor2vector((symtensor2<long double>)t2sr);
  vector<long double> v(6);
  v[1] = t2sr(1,1);
  v[2] = t2sr(2,2);
  v[3] = t2sr(3,3);
  v[4] = sqrt(2) * t2sr(2,3);
  v[5] = sqrt(2) * t2sr(1,3);
  v[6] = sqrt(2) * t2sr(1,2);
  if (detail) affiche("symtensor2vector", abs( (t2sr|t2sr) - v2sr*v2sr) < epsilon && v==v2sr);
  else result *= (abs( (t2sr|t2sr) - v2sr*v2sr) < epsilon && v==v2sr);

  if (detail) affiche("vector2symtensor", walpole::vector2symtensor(v2sr) == t2sr);
  else result *= (walpole::vector2symtensor(v2sr) == t2sr);

  long double E1 = 20.440;
  long double nu12 = 0.1027;
  long double E3 = 11.306;
  long double nu31 = 0.1798;
  long double G13 = 1.5851;
  long double C11 = E1 * ( -E3 + E1 * power (nu31,2)) / ((1. + nu12) * (E3 * (-1  + nu12) + 2. * E1 * power (nu31,2)));
  long double C44 = G13;
  long double C13 = ( E1 * E3 * nu31) / ( E3 - E3 * nu12 - 2. * E1 * power (nu31,2));
  long double C12 = - E1 * ( E3 * nu12 + E1 * power (nu31,2)) / ((1. + nu12) * (E3 * (-1  + nu12) + 2. * E1 * power (nu31,2))) ;
  
  long double C33 = power (E3,2) * (-1 + nu12) / ( E3 * (-1 + nu12) + 2 * E1 * power (nu31,2));
  tensor4<long double> C(3);
  C(1,1,1,1) = C(2,2,2,2) = C11;
  C(3,3,3,3) = C33;
  C(2,3,2,3) = C(2,3,3,2) = C(3,2,2,3) = C(3,2,3,2) = C(1,3,1,3) = C(1,3,3,1) = C(3,1,1,3) = C(3,1,3,1)= C44;
  C(1,2,1,2) = C(1,2,2,1) = C(2,1,1,2) = C(2,1,2,1) = 0.5 * (C11 - C12);
  C(1,1,2,2) = C(2,2,1,1) = C12;
  C(1,1,3,3) = C(3,3,1,1) = C(2,2,3,3) = C(3,3,2,2) = C13;

  matrix<long double> mat(6,6);
  mat(1,1) = C(1,1,1,1);
  mat(2,2) = C(2,2,2,2);
  mat(3,3) = C(3,3,3,3);
  mat(1,2) = mat(2,1) = C(1,1,2,2);
  mat(1,3) = mat(3,1) = C(1,1,3,3);
  mat(2,3) = mat(3,2) = C(2,2,3,3);
  mat(4,4) = 2 * C(2,3,2,3);
  mat(5,5) = 2 * C(1,3,1,3);
  mat(6,6) = 2 * C(1,2,1,2);

  if (detail) affiche ("symtensor2matrix", mat == walpole::symtensor2matrix (C));
  else result *= (mat == walpole::symtensor2matrix (C));

  if (detail) affiche("matrix2symtensor", walpole::matrix2symtensor(mat) == C);
  else result *= (walpole::matrix2symtensor(mat) == C);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                     walpole test passed" << reset;
  else cout << red << "                     walpole test failed" << reset;
  cout << "============================================================== \n";

  return result;  
}


#endif
