/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2009,2012 COLLARD Christophe
 * copyright © 2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2009 Arts et Métiers ParisTech
 * copyright © 2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    PII-tests belongs to Material Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type PII test
#endif

#ifndef __PII_test_hpp
#define __PII_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __parameters_h
#include "parameters.h"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __isotropic_elasticity_tensors_hpp
#include "MateriOL++/isotropic elasticity tensors.hpp"
#endif

#ifndef __PII_hpp
#include "MateriOL++/PII.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace materiol;


//=======================
int test_PII (int detail)
//=======================
{
  int result=1;
  bool test = true;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                       PII test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  long double E1 = 20.440;
  long double nu12 = 0.1027;
  long double E3 = 11.306;
  long double nu31 = 0.1798;
  long double G13 = 1.5851;
  long double C11 = E1 * ( -E3 + E1 * power (nu31,2)) / ((1. + nu12) * (E3 * (-1  + nu12) + 2. * E1 * power (nu31,2)));
  long double C44 = G13;
  long double C13 = ( E1 * E3 * nu31) / ( E3 - E3 * nu12 - 2. * E1 * power (nu31,2));
  long double C12 = - E1 * ( E3 * nu12 + E1 * power (nu31,2)) / ((1. + nu12) * (E3 * (-1  + nu12) + 2. * E1 * power (nu31,2))) ;
  
  long double C33 = power (E3,2) * (-1 + nu12) / ( E3 * (-1 + nu12) + 2 * E1 * power (nu31,2));
  tensor4<long double> C(3);
  C(1,1,1,1) = C(2,2,2,2) = C11;
  C(3,3,3,3) = C33;
  C(2,3,2,3) = C(2,3,3,2) = C(3,2,2,3) = C(3,2,3,2) = C(1,3,1,3) = C(1,3,3,1) = C(3,1,1,3) = C(3,1,3,1)= C44;
  C(1,2,1,2) = C(1,2,2,1) = C(2,1,1,2) = C(2,1,2,1) = 0.5 * (C11 - C12);
  C(1,1,2,2) = C(2,2,1,1) = C12;
  C(1,1,3,3) = C(3,3,1,1) = C(2,2,3,3) = C(3,3,2,2) = C13;

  PII<long double> Pii(1000,1000);
  vector<long double> geo(3);

  geo[1] = 1;
  geo[2] = 1;
  geo[3] = 0.25;

  symmatrix<long double> P(6,6);
  P(1,1) = P(2,2) = 0.0190017763428615;
  P(2,1) = -0.00313041723110433;
  P(3,1) = P(2,3) = -0.00632187247542117;
  P(3,3) = 0.0729745440741563;
  P(4,4) = 0.0221321935739658;
  P(5,5) = P(6,6) = 0.147351047300244;

  test = (symtensor2matrix (Pii.ellipsoid (C,geo)) == P);
  if (detail) affiche ("ellipsoid", test);
  else result *= (test);

  isotropic_elasticity_tensor<long double> Ciso;
  Ciso.Lame (120000);
  Ciso.Shear (80000);
  geo[3] = 0.9999999999999999;
  test = (Pii.ellipsoid (Ciso, geo) == Pii.sphere (Ciso));
  if (detail) affiche ("sphere", test);
  else result *= (test);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                       PII test passed" << reset;
  else cout << red << "                       PII test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
