/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 0.1.6                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2005,2006 COLLARD Christophe
 * copyright  2005,2006 BERBENNI Stephane
 * copyright  2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    tests-materials belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type interface.
#endif

#if !defined(__IOMANIP_H)
#include <iomanip>
#endif

#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__ASSERT_H)
#include <time.h>
#endif

#if !defined(__ISOTROPIC_TENSORS_TEST_H)
#include"isotropic tensors-test.h"
#endif

#if !defined(__ISOTROPIC_ELASTICITY_TENSORS_TEST_H)
#include"isotropic elasticity tensors-test.h"
#endif

#if !defined(__CUBIC_TENSORS_TEST_H)
#include"cubic tensors-test.h"
#endif

#if !defined(__CUBIC_ELASTICITY_TENSORS_TEST_H)
#include"cubic elasticity tensors-test.h"
#endif

#if !defined(__TII_TEST_H)
#include"TII-test.h"
#endif

//#if !defined(__TIJ_TEST_H)
//#include"../materials/TIJ-test.h"
//#endif

#if !defined(__ESHELBY_TEST_H)
#include"Eshelby-test.h"
#endif

#if !defined(__MATERIALS_TOOLBOX_TEST_H)
#include"MatOoLbox-test.h"
#endif

using namespace std;


main()
{
  int detail; // parameter to write/hide test procedure
  bool result = true;
  clock_t start, end;
  clock_t start_main, end_main;

  detail = 0;
  start_main = start = clock();
  if (detail)
    //=======================================================================
    cout<< "-----------------------isotropic tensor---------------------- \n";
    //=======================================================================
  result *= test_isotropic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-----------------isotropic elasticity tensor----------------- \n";
    //=======================================================================
  result *= test_isotropic_elasticity_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "------------------------cubic tensor------------------------- \n";
    //=======================================================================
  result *= test_cubic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-------------------cubic elasticity tensor------------------- \n";
    //=======================================================================
  result *= test_cubic_elasticity_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-----------------------------TII----------------------------- \n";
    //=======================================================================
  result *= test_TII(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  /*
  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-----------------------------TIJ----------------------------- \n";
    //=======================================================================
  result *= test_TIJ(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;
  */

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "---------------------------Eshelby--------------------------- \n";
    //=======================================================================
  result *= test_Eshelby(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "--------------------------MatOolbox-------------------------- \n";
    //=======================================================================
  result *= test_MatOoLbox(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  end_main = clock();

  bool test = true;
  ifstream file("../simula+.log", ios::in);
  if (!file.fail())
    file >> test;
  file.close();
  test *= result;
  ofstream file2("../simula+.log", ios::out);
  assert (!file2.fail());
  file2 << test;
  file2.close();

  cout << "============================================================== \n";
  if (result) cout << "-------OK-----------end of MateriOL++ tests-----------OK------ \n";
  else cout << "-----FAILED---------end of MateriOL++ tests---------FAILED---- \n";
  cout << "============================================================== \n";

  cout<<"cpu time : " << (long double)(end_main-start_main)/CLOCKS_PER_SEC << endl;
}
