function [env_name, env_PID, env_path] = computing_env_info( )
% Copyright (C) 2006,2007,2008,2009,2010 Daniele de Rigo 
% 
% This file is part of Mastrave.
% 
% Mastrave is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% Mastrave is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with Mastrave.  If not, see <http://www.gnu.org/licenses/>.
% 
% ---------------------------------------------------------------------------
% 
% [env_name, env_PID, env_path] = computing_env_info( )
%
% Return the name <env_name> of the computing environment which is
% currently interpreting the function, its PID <env_PID> and its full
% filesystem path <env_path>.
%
% 
% Shell requirements: grep, perl, pstree, which
%
%
% version: 0.1.7


% mastrave-kernel: this function is designed to avoid abnormal terminations

[ env_name, env_PID, env_path ] = deal( '' );

[ status , answer ] = unix(                                         ...
   [                                                                ...
      'pstree -p -H $PPID |'                                        ...
      'grep -E $PPID |'                                             ...
      'perl -p -e ''s!'                                             ...
         '^.*?((?:matlab|octave)[ 0-9.-_]*)\([ ]*([0-9]+)[ ]*\).*!' ...
         '\1=\2!i'' |'                                              ...
      'perl -p -e ''s!^\s*(.*?)\s*$!\1!'' '                         ...
   ]                                                                ...
);

% in case of error, return default empty strings 
if( status )
   return
end

sep      = find( answer == '=' );

env_name = tolower( answer(1:sep-1) );
env_PID  = answer(sep+1:end);

[ status , answer ] = unix(                                         ...
   sprintf(                                                         ...
      'which %s 2> /dev/null | %s' ,                                ...
      env_name                     ,                                ...
      'perl -p -e ''s!^\s*(.*?)\s*$!\1!'' '                         ...
   )                                                                ...
);

if( ~status )
   env_path = answer;
   return
end

[ status , answer ] = unix(                                         ...
   sprintf(                                                         ...
      'which %s 2> /dev/null | %s' ,                                ...
      toupper( env_name )          ,                                ...
      'perl -p -e ''s!^\s*(.*?)\s*$!\1!'' '                         ...
   )                                                                ...
);

if( ~status )
   env_path = answer;
   return
end

[ status , answer ] = unix(                                         ...
   sprintf(                                                         ...
      'which %s%s 2> /dev/null | %s' ,                              ...
      toupper( env_name(1) )         ,                              ...
      env_name( 2:end )              ,                              ...
      'perl -p -e ''s!^\s*(.*?)\s*$!\1!'' '                         ...
   )                                                                ...
);

if( ~status )
   env_path = answer;
   return
end


% Local Variables:
% mode:mastrave
% End:

