#!$<$perl_path$>$

###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

use lib '$<$pathFile$>$/inc';
use strict;
use warnings;

#use myFunctionAlg;
use myFunctionDB;
use myFunctionUtils;
use myFunctionShell;

# clear the screen
myFunctionShell::clearScreen;

# Header of 'sync_switch.pl'
myFunctionShell::printHeader($0);

# it gets from you an switch's ip address
my ( $idSwitch, $checkedIDswitch );

# Eval if defined IP
if ( defined( $ARGV[0] ) ) {
    $idSwitch        = $ARGV[0];
    $checkedIDswitch = myFunctionUtils::checkIDswitch($idSwitch);
}
else {
    $checkedIDswitch = 0;    # False
}

# it gets from you a switch's ip address
while ( !$checkedIDswitch ) {
    print "\n\tPlease, You must insert a switch ID:\t";
    $idSwitch = <STDIN>;
    chomp $idSwitch;
    $checkedIDswitch = myFunctionUtils::checkIDswitch($idSwitch);
}

# it makes reachability test
#if (myFunctionNet::testReachability($IP)) {
#    print "\nok\n";
#} else {
#    print "\nno ok\n";
#}

#### Connect to DB
my $dbh = myFunctionDB::connectToDB;

# it asks: sync?
my ($risp);

if ( defined( $ARGV[1] ) ) {
    $risp = lc( $ARGV[1] );
}
else { $risp = 'cicla'; }

while ( !( ( $risp eq 'e' ) || ( $risp eq 'd' ) ) ) {
    print "\n\n\tEnable the switch? [E/D] ";
    $risp = <STDIN>;
    chomp $risp;
    $risp = lc($risp);
}

if ( $risp eq 'd' ) {

    # Now NOT sync
    print "\n\n\tStarting DISABLE the switch...";

    my %switchParams = ( disable => '1' );
    my $query_where = 'id=' . $idSwitch;
    myFunctionDB::setSwitchParamsFromID( $dbh, $idSwitch, \%switchParams,
        $query_where );
    print ' done';
}
else {

    # Now sync data switch with data DB
    print "\n\n\tStarting ENABLE the switch...";

    my %switchParams = ( disable => '0' );

    my $query_where = 'id=' . $idSwitch;
    myFunctionDB::setSwitchParamsFromID( $dbh, $idSwitch, \%switchParams,
        $query_where );
    print ' done';
}

# press type to continue...
myFunctionShell::typeToContinue;

exit 0;
