###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

package myFunctionAlg;

use strict;
use warnings;

use ParamSNMP qw(:config);

use myFunctionUtils;

# This function upload DB, but clear the MAC associates with the uplink port
sub UploadDBrawMAC {
    my ( $tableMAC, $tablePort, $tableStatus, $ipSwitch, $idSwitch,
        $ref_MACSwitch, $idTimeShoot, $dbh )
      = @_;

    # It cleans up undefined/incomplete 'value' from respective tables.
    # (The 'value' can to be MAC, port and status).
    # Is an error of SNMP session?
    myFunctionUtils::traceLog(
"\nI have only raw tables. Now cleans up\nundefined/incomplete oid from tables.",
        1
    );
    clearUpTables( $tableMAC, $tablePort, $tableStatus );

    # It cleans all 'value' in uplink port from respective tables.
    # (The 'value' can to be MAC, port and status).
    myFunctionUtils::traceLog( "\nNow I'm cleaning all oids in uplink port.",
        1 );
    myFunctionAlg::clearTablesFromUplink( $tableMAC, $tablePort, $tableStatus,
        $ref_MACSwitch );

    # Now, It inserts mac/port/status in db.
    #    my $timeShoot = myFunctionUtils::timeNow();
    foreach my $oid ( keys( %{$$tableMAC} ) ) {
        my $oidPort = $oid;
        $oidPort =~ s/^$mac_list/$mac_port/;
        my $oidStatus = $oid;
        $oidStatus =~ s/^$mac_list/$mac_status/;
        if (    ( defined $$tableMAC->{$oid} )
            and ( defined $$tablePort->{$oidPort} )
            and ( defined $$tableStatus->{$oidStatus} ) )
        {

            # Trasform mac address in lower case (for being sure!!)
            $$tableMAC->{$oid} = lc( $$tableMAC->{$oid} );

            my $msg =
"mac = $$tableMAC->{$oid}\t port = $$tablePort->{$oidPort}\t status = $$tableStatus->{$oidStatus}... inserting/updating into db.";
            myFunctionUtils::traceLog( $msg, 2 );
        }
        else {
            myFunctionUtils::traceLog( "There is something _not_ defined", 2 );
        }
        myFunctionDB::updateLocation(
            $$tableMAC->{$oid}, $idSwitch,
            $$tablePort->{$oidPort},
            $$tableStatus->{$oidStatus},
            $idTimeShoot, $dbh
        );
    }
}

# It cleans up many 'values' (These 'values' can
# to be MAC, port and status). These values is on
# uplink port.
sub clearTablesFromUplink {
    my ( $tableMAC, $tablePort, $tableStatus, $ref_MACSwitch ) = @_;
    foreach my $mac (@$ref_MACSwitch) {
        foreach my $oid ( keys( %{$$tableMAC} ) ) {
            if (    ( defined $$tableMAC->{$oid} )
                and ( $$tableMAC->{$oid} eq $mac ) )
            {
                my $oidPort = $oid;
                $oidPort =~ s/^$mac_list/$mac_port/;
                my $port = $$tablePort->{$oidPort};
                foreach my $oidPort ( keys( %{$$tablePort} ) ) {
                    $oid = $oidPort;
                    $oid =~ s/^$mac_port/$mac_list/;
                    if ( $$tablePort->{$oidPort} eq $port ) {
                        my $oidStatus = $oidPort;
                        $oidStatus =~ s/^$mac_port/$mac_status/;
                        if ( defined $$tableMAC->{$oid} ) {
                            my $msg =
"mac = $$tableMAC->{$oid}... delete entries because these entries is on uplink port.";
                            myFunctionUtils::traceLog( $msg, 3 );
                        }
                        else { myFunctionUtils::traceLog( "defined??", 3 ); }
                        delete $$tableMAC->{$oid};
                        delete $$tablePort->{$oidPort};
                        delete $$tableStatus->{$oidStatus};
                    }
                }
            }
        }
    }
}

# It cleans up undefined/incomplete 'value' (The 'value' can
# to be MAC, port and status). Is an error of SNMP session?
sub clearUpTables {
    my ( $tableMAC, $tablePort, $tableStatus ) = @_;
    foreach my $oid ( keys( %{$$tableMAC} ) ) {
        $$tableMAC->{$oid} =
          myFunctionUtils::cleanedUpMAC( $$tableMAC->{$oid} );
        my $oidPort = $oid;
        $oidPort =~ s/^$mac_list/$mac_port/;
        my $oidStatus = $oid;
        $oidStatus =~ s/^$mac_list/$mac_status/;
        if (   ( !defined $$tablePort->{$oidPort} )
            or ( !defined $$tablePort->{$oidPort} ) )
        {
            my $msg =
"mac = $$tableMAC->{$oid}... delete entries because values in tablePort or tableStatus isn't defined.";
            myFunctionUtils::traceLog( $msg, 3 );
            delete $$tableMAC->{$oid};
            delete $$tablePort->{$oidPort};
            delete $$tableStatus->{$oidStatus};
        }
    }

    #    foreach my $oidPort (oid_lex_sort(keys(%{$tablePort}))) {
    foreach my $oidPort ( keys( %{$$tablePort} ) ) {
        if ( $$tablePort->{$oidPort} eq "0" ) {
            my $oid = $oidPort;
            $oid =~ s/^$mac_port/$mac_list/;
            my $oidStatus = $oid;
            $oidStatus =~ s/^$mac_list/$mac_status/;
            if ( defined $$tableMAC->{$oid} ) {
                my $msg = "mac = "
                  . $$tableMAC->{$oid}
                  . "... delete entries from all table because this is switch's physical address.";
                myFunctionUtils::traceLog( $msg, 3 );
            }
            delete $$tableMAC->{$oid};
            delete $$tablePort->{$oidPort};
            delete $$tableStatus->{$oidStatus};
        }
    }
}

1;
