###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

package ParamDB;

use strict;
use warnings;

BEGIN {
    use Exporter;

    our @ISA = qw(Exporter);
    our (%EXPORT_TAGS);

    $EXPORT_TAGS{'config'} = [
        qw($sql_server $sql_db $sql_user $sql_pwd $sql_host $DBlistSwitch $DBlistMAC $DBlistLocation $DBmalTimeShoot)
    ];
    Exporter::export_ok_tags('config');
}

our $sql_db     = '$<$mysqlDB$>$';
our $sql_user   = '$<$userDB$>$';
our $sql_pwd    = '$<$pwdDB$>$';
our $sql_host   = '$<$hostDB$>$';
our $sql_server = 'mysql';

# List of tables in DB
our $DBlistSwitch   = 'mal_switch';
our $DBlistMAC      = 'mal_macAddress';
our $DBlistLocation = 'mal_location';
our $DBmalTimeShoot = 'mal_timeShoot';

1;
