/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <glib.h>
#include <stdlib.h>
#include <getopt.h>
#include <config.h>
#include "interface.h"
#include "card.h"
#include "config_utils.h"
#include "main.h"

#include <libmt_client.h>



/* static struct option lopts[] = { */
/*   {"help", no_argument, 0, 'h'}, */
/*   {"version", no_argument, 0, 'v'}, */
/*   {"port", required_argument, 0, 'p'}, */
/*   {"server", required_argument, 0, 's'}, */
/*   {"name", required_argument, 0, 'n'}, */
/*   {NULL, 0, NULL, 0} */
/* }; */

gint nb_player = 4;
gint nb_hand_card = 18;
gint nb_chien_card = 6;

config_t *config;

extern gint player_client_init (libmt_client_player_t * player);
extern gint player_client_game_init (libmt_client_player_t * player);
extern gint player_client_make_bid (libmt_client_player_t * player);
extern gint player_client_make_chien (libmt_client_player_t * player);
extern gint player_client_not_make_chien (libmt_client_player_t * player);
extern gint player_client_choose_card (libmt_client_player_t * player);
extern gint player_client_draw (libmt_client_player_t * player);
extern gint player_client_remove_card (libmt_client_player_t * player);
extern gint player_client_ack_replay (libmt_client_player_t * player);
extern gint player_client_lost_connection (libmt_client_player_t * player);
extern gint player_client_normal_close (libmt_client_player_t * player);



int
main (int argc, char **argv)
{
  libmt_client_player_t player;

  config = config_read (argc, argv);
  if (!config)
    {
      g_error (_("Could not initialize the config"));
    }
/* else { */
/*     printf ("Dump of the xml file into /tmp/config.xml\n\n"); */
/*     libmt_xmlconfig_write_file ("/tmp/config.xml", FALSE); */
/*     config_print (config); */
/*     exit (0); */
/*   } */

  g_thread_init (NULL);

  init_screen ();

  init_card ();

  libmt_client_init (&player, nb_player, nb_hand_card, nb_chien_card);

  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_INIT, player_client_init);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_GAME_INIT,
			      player_client_game_init);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_MAKE_BID,
			      player_client_make_bid);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_MAKE_CHIEN,
			      player_client_make_chien);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_NOT_MAKE_CHIEN,
			      player_client_not_make_chien);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_CHOOSE_CARD,
			      player_client_choose_card);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_DRAW, player_client_draw);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_REMOVE_CARD,
			      player_client_remove_card);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_LOST_CONNECTION,
			      player_client_lost_connection);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_NORMAL_CLOSE,
			      player_client_normal_close);
  libmt_client_init_callback (LIBMT_CLIENT_FUNCTION_ACK_REPLAY,
			      player_client_ack_replay);

  libmt_client_main_loop (&player, config->host_name, config->port, CLIENT_ID,
			  CLIENT_VERSION);

  g_string_free (config->host_name, TRUE);
  g_string_free (config->player_name, TRUE);

  close_screen (0);

  return (0);
}




void
show_usage (gchar * prog_name)
{
  g_printerr (_
	      ("%s [-h | --help] [-v | --version] [-p | --port port] [-s | --server server] [-n | --name name]\n"),
	      prog_name);
  g_printerr (_("    -h, --help             Gives this help display.\n"));
  g_printerr (_("    -v, --version          Display program version.\n"));
  g_printerr (_("    -p, --port port        Set the port.\n"));
  g_printerr (_("    -s, --server server    Set the server name.\n"));
  g_printerr (_("    -n, --name name        Set the player name.\n"));
}
