/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libintl.h>
#define _(a) gettext (a)
#define N_(a) a
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <libmt_client.h>
#include "player.h"
#include "defs.h"
#include "gui.h"


#define DONE_OK    1
#define DONE_NO    0
#define DONE_SHOW  2


static gint done;
static GtkWidget *button;


typedef struct
{
  gint card;
  libmt_client_player_t *player;
}
player_clicked_data_t;


static void show_last_turn (GtkWidget * wid, gpointer data);
static void hide_last_turn (GtkWidget * wid, gpointer data);



static void
redraw_choose_card (GtkWidget * win, GdkEventConfigure * evt, gpointer data)
{
  player_client_redraw_card_played (win, evt, data);

  gtk_widget_queue_resize (GTK_WIDGET (gui_mainwin));
}



static void
card_clicked (GtkWidget * wid, GdkEventButton * evt_but, gpointer data)
{
  player_clicked_data_t *click_card = data;

  click_card->player->card_play = click_card->card;

  if (done == DONE_NO)
    done = DONE_OK;
  else
    hide_last_turn (button, click_card->player);
}



static void
hide_last_turn (GtkWidget * wid, gpointer data)
{
  libmt_client_player_t *player = data;
  gint i;

  gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
		      _("Please, choose a card to play."));

  gtk_button_set_label (GTK_BUTTON (button), _("Show\nLast _turn"));
  g_signal_handlers_destroy (G_OBJECT (button));
  g_signal_connect (G_OBJECT (button), "clicked",
		    G_CALLBACK (show_last_turn), player);

  for (i = 0; i < player->nb_player; i++)
    {
      if (player->card_previous_turn[i] != -1)
	gtk_layout_move (GTK_LAYOUT (gui_layout),
			 gui_card_img[player->card_previous_turn[i]],
			 X_HIDE, Y_HIDE);
    }

  gui_set_redraw_func (redraw_choose_card, player);
  gui_do_redraw ();

  done = DONE_NO;
}



static void
draw_show_last_turn (GtkWidget * win, GdkEventConfigure * evt, gpointer data)
{
  gint width, height;
  libmt_client_player_t *player = data;
  gint i, pl;
  gint posx, posy;

  player_client_redraw_base (win, evt, player);

  gui_layout_get_size (evt, &width, &height);

  for (i = 0, pl = player->place; i < player->nb_player; i++)
    {
      if (player->card_turn[pl] != -1)
	gtk_layout_move (GTK_LAYOUT (gui_layout),
			 gui_card_img[player->card_turn[pl]], X_HIDE, Y_HIDE);

      if (player->card_previous_turn[pl] != -1)
	{
	  switch (i)
	    {
	    case 0:
	      posx = (width - gui_card_width) / 2;
	      posy = (height - gui_card_height) / 2 + 5;
	      break;
	    case 1:
	      posx = (width - 3 * gui_card_width) / 2 - 5;
	      posy = height / 2 - gui_card_height;
	      break;
	    case 2:
	      posx = (width - gui_card_width) / 2;
	      posy = (height - 3 * gui_card_height) / 2 - 5;
	      break;
	    case 3:
	      posx = (width + gui_card_width) / 2 + 5;
	      posy = height / 2 - gui_card_height;
	      break;
	    default:
	      posx = 10 * i;
	      posy = 50;
	      break;
	    }
	  gtk_layout_move (GTK_LAYOUT (gui_layout),
			   gui_card_img[player->card_previous_turn[pl]],
			   posx, posy);
	}
      pl += 1;
      if (pl >= player->nb_player)
	pl = 0;
    }

  gtk_widget_queue_resize (GTK_WIDGET (gui_mainwin));
}


static void
show_last_turn (GtkWidget * wid, gpointer data)
{
  libmt_client_player_t *player = data;

  gui_set_redraw_func (draw_show_last_turn, player);
  gui_do_redraw ();

  gtk_button_set_label (GTK_BUTTON (button), _("Hide\nLast _turn"));

  g_signal_handlers_destroy (G_OBJECT (button));
  g_signal_connect (G_OBJECT (button), "clicked",
		    G_CALLBACK (hide_last_turn), player);


  gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
		      _("This is the last trun played."));

  done = DONE_SHOW;
}


gint
player_client_choose_card (libmt_client_player_t * player)
{
  gint width, height;
  player_clicked_data_t click_card[MAX_HAND_CARD];
  gint i, ok;

  gdk_threads_enter ();

  gtk_layout_get_size (GTK_LAYOUT (gui_layout), &width, &height);

  /* status bar */
  gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
		      _("Please, choose a card to play."));

  for (i = 0; i < player->nb_hand_card; i++)
    {
      if (player->card[i] != -1)
	{
	  click_card[i].card = player->card[i];
	  click_card[i].player = player;
	  g_signal_connect (G_OBJECT (gui_card_img[player->card[i]]),
			    "button-press-event", G_CALLBACK (card_clicked),
			    &click_card[i]);
	}
    }

  for (i = 0, ok = 0; i < player->nb_player; i++)
    {
      if (player->card_previous_turn[i] != -1)
	ok = 1;
    }
  if (ok == 1)
    {
      button = gtk_button_new_with_label (_("Show\nLast _turn"));
      gtk_button_set_use_underline (GTK_BUTTON (button), TRUE);
      gtk_layout_put (GTK_LAYOUT (gui_layout), button, 5, 5);
      g_signal_connect (G_OBJECT (button), "clicked",
			G_CALLBACK (show_last_turn), player);
    }

  gtk_widget_show_all (gui_mainwin);

  gui_set_redraw_func (redraw_choose_card, player);
  gui_do_redraw ();

  gdk_threads_leave ();

  done = DONE_NO;

  while (done != DONE_OK)
    {
      /* put chat part here! */
      usleep (100);
    }

  gdk_threads_enter ();

  for (i = 0; i < player->nb_hand_card; i++)
    {
      if (player->card[i] != -1)
	{
	  g_signal_handlers_destroy (G_OBJECT
				     (gui_card_img[player->card[i]]));
	}
    }

  if (ok == 1)
    {
      gtk_widget_destroy (button);

      for (i = 0; i < player->nb_player; i++)
	{
	  if (player->card_previous_turn[i] != -1)
	    gtk_layout_move (GTK_LAYOUT (gui_layout),
			     gui_card_img[player->card_previous_turn[i]],
			     X_HIDE, Y_HIDE);
	}

      gui_set_redraw_func (redraw_choose_card, player);
      gui_do_redraw ();
    }

  gdk_threads_leave ();

  return (0);
}





/********************/
/* End of turn part */
/********************/



static void
player_client_redraw_previous_turn (GtkWidget * win, GdkEventConfigure * evt,
				    gpointer data)
{
  gint width, height;
  libmt_client_player_t *player = data;
  gint i, pl;
  gint posx, posy;

  player_client_redraw_base (win, evt, player);

  gui_layout_get_size (evt, &width, &height);

  for (i = 0, pl = player->place; i < player->nb_player; i++)
    {
      if (player->card_previous_turn[pl] != -1)
	{
	  switch (i)
	    {
	    case 0:
	      posx = (width - gui_card_width) / 2;
	      posy = (height - gui_card_height) / 2 + 5;
	      break;
	    case 1:
	      posx = (width - 3 * gui_card_width) / 2 - 5;
	      posy = height / 2 - gui_card_height;
	      break;
	    case 2:
	      posx = (width - gui_card_width) / 2;
	      posy = (height - 3 * gui_card_height) / 2 - 5;
	      break;
	    case 3:
	      posx = (width + gui_card_width) / 2 + 5;
	      posy = height / 2 - gui_card_height;
	      break;
	    default:
	      posx = 10 * i;
	      posy = 50;
	      break;
	    }
	  gtk_layout_move (GTK_LAYOUT (gui_layout),
			   gui_card_img[player->card_previous_turn[pl]],
			   posx, posy);
	}
      pl += 1;
      if (pl >= player->nb_player)
	pl = 0;
    }

  gtk_widget_queue_resize (GTK_WIDGET (gui_mainwin));
}


static void
end_of_turn_card_clicked (GtkWidget * wid, GdkEventButton * evt_but,
			  gpointer data)
{
  done = 1;
}


void
player_client_wait_end_of_turn (libmt_client_player_t * player)
{
  gint width, height;
  gint i, pl;
  GString *st;

  gdk_threads_enter ();

  gtk_layout_get_size (GTK_LAYOUT (gui_layout), &width, &height);

  /* status bar */
  gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
		      _
		      ("End of turn. Please, click on cards to play next turn."));

  for (i = 0; i < player->nb_player; i++)
    {
      if (player->card_previous_turn[i] != -1)
	{
	  g_signal_connect (G_OBJECT
			    (gui_card_img[player->card_previous_turn[i]]),
			    "button-press-event",
			    G_CALLBACK (end_of_turn_card_clicked), NULL);
	}
    }

  /* Update scores */
  st = g_string_new ("");

  for (i = 0, pl = player->place; i < player->nb_player; i++)
    {
      g_string_printf (st, "%d", player->score[pl]);
      gtk_label_set_text (GTK_LABEL (player_label_score[pl]), st->str);

      pl += 1;
      if (pl >= player->nb_player)
	pl = 0;
    }

  g_string_free (st, TRUE);


  gui_set_redraw_func (player_client_redraw_previous_turn, player);
  gui_do_redraw ();

  gdk_threads_leave ();

  done = 0;

  while (done == 0)
    {
      /* put chat part here! */
      usleep (100);
    }

  gdk_threads_enter ();

  for (i = 0; i < player->nb_player; i++)
    {
      if (player->card_previous_turn[i] != -1)
	{
	  g_signal_handlers_destroy (G_OBJECT
				     (gui_card_img
				      [player->card_previous_turn[i]]));
	  gtk_layout_move (GTK_LAYOUT (gui_layout),
			   gui_card_img[player->card_previous_turn[i]],
			   X_HIDE, Y_HIDE);
	}
    }

  gdk_threads_leave ();
}
